/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public final class DrawingUtils {
    public static final int BLACK = 1;

    public static void drawTexturedRect(int x, int y, int width, int height) {
        DrawingUtils.drawTexturedRect(x, y, 0, 0, width, height, width, height);
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        DrawingUtils.drawTexturedFlippedRect(x, y, u, v, width, height, textureWidth, textureHeight, false, false);
    }

    public static void drawTexturedFlippedRect(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, boolean flipX, boolean flipY) {
        float f = 1.0f / (float)textureWidth;
        float f1 = 1.0f / (float)textureHeight;
        int u1 = flipX ? u + width : u;
        int u2 = flipX ? u : u + width;
        int v1 = flipY ? v + height : v;
        int v2 = flipY ? v : v + height;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)((float)u1 * f), (double)((float)v2 * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)u2 * f), (double)((float)v2 * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((float)u2 * f), (double)((float)v1 * f1)).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)((float)u1 * f), (double)((float)v1 * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedStretchedRect(int x, int y, int u, int v, int finalWidth, int finalHeight, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + finalHeight), 0.0).func_187315_a((double)u, (double)(v + height)).func_181675_d();
        buffer.func_181662_b((double)(x + finalWidth), (double)(y + finalHeight), 0.0).func_187315_a((double)(u + width), (double)(v + height)).func_181675_d();
        buffer.func_181662_b((double)(x + finalWidth), (double)y, 0.0).func_187315_a((double)(u + width), (double)v).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)u, (double)v).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawGlitchRect(Random random, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, boolean flipX, boolean flipY) {
        for (int i = 0; i < height; ++i) {
            if (flipY) {
                i = height - i - 1;
            }
            int offset = random.nextInt(4) == 0 ? random.nextInt(6) - 3 : 0;
            DrawingUtils.drawTexturedFlippedRect(x + offset, y + i, u, v + i, width, 1, textureWidth, textureHeight, flipX, flipY);
        }
    }

    public static int mix(int colour1, int colour2, float proportion) {
        proportion = MathHelper.func_76131_a((float)proportion, (float)0.0f, (float)1.0f);
        int r1 = colour1 >> 16 & 0xFF;
        int g1 = colour1 >> 8 & 0xFF;
        int b1 = colour1 & 0xFF;
        int r2 = colour2 >> 16 & 0xFF;
        int g2 = colour2 >> 8 & 0xFF;
        int b2 = colour2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * proportion);
        int g = (int)((float)g1 + (float)(g2 - g1) * proportion);
        int b = (int)((float)b1 + (float)(b2 - b1) * proportion);
        return (r << 16) + (g << 8) + b;
    }

    public static int makeTranslucent(int colour, float opacity) {
        return colour + ((int)(opacity * 255.0f) << 24);
    }

    public static void drawScaledStringToWidth(FontRenderer font, String text, float x, float y, float scale, int colour, float width, boolean centre, boolean alignR) {
        float textWidth = (float)font.func_78256_a(text) * scale;
        float textHeight = (float)font.field_78288_b * scale;
        if (textWidth > width) {
            scale *= width / textWidth;
        } else if (alignR) {
            x += width - textWidth;
        }
        if (centre) {
            y += ((float)font.field_78288_b - textHeight) / 2.0f;
        }
        DrawingUtils.drawScaledTranslucentString(font, text, x, y, scale, colour);
    }

    public static void drawScaledTranslucentString(FontRenderer font, String text, float x, float y, float scale, int colour) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        font.func_175063_a(text, x /= scale, y /= scale, colour);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public static void drawItemAndTooltip(GuiContainer gui, ItemStack stack, int x, int y, int mouseX, int mouseY, boolean tooltip) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179145_e();
        renderItem.field_77023_b = 100.0f;
        if (!stack.func_190926_b()) {
            renderItem.func_180450_b(stack, x, y);
            renderItem.func_175030_a(Minecraft.func_71410_x().field_71466_p, stack, x, y);
            if (tooltip) {
                gui.func_146283_a(gui.func_191927_a(stack), mouseX + gui.getXSize() / 2 - gui.field_146294_l / 2, mouseY + gui.getYSize() / 2 - gui.field_146295_m / 2);
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    public static float smoothScaleFactor(int lifetime, int ticksExisted, float partialTicks, int startLength, int endLength) {
        float age = (float)ticksExisted + partialTicks;
        float s = MathHelper.func_76131_a((float)(age < (float)startLength || lifetime < 0 ? age / (float)startLength : ((float)lifetime - age) / (float)endLength), (float)0.0f, (float)1.0f);
        s = (float)Math.pow(s, 0.4);
        return s;
    }

    public static boolean isPointInRegion(int left, int top, int width, int height, int x, int y) {
        return x >= left - 1 && x < left + width + 1 && y >= top - 1 && y < top + height + 1;
    }
}

