/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.particle;

import electroblob.wizardry.client.particle.ParticleTargeted;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ParticleVine
extends ParticleTargeted {
    private static final float THICKNESS = 0.02f;
    private static final float LEAF_SPACING = 0.5f;
    private static final float SEGMENT_LENGTH = 1.0f;
    private static final ResourceLocation STEM_TEXTURE = new ResourceLocation("ebwizardry", "particle/vine");
    private static final ResourceLocation[] LEAF_TEXTURES = ParticleVine.generateTextures("vine_leaf", 5);

    public ParticleVine(World world, double x, double y, double z) {
        super(world, x, y, z, STEM_TEXTURE);
        this.func_187114_a(0);
        this.field_70544_f = 1.0f;
        this.func_70538_b(0.2f, 0.65f, 0.0f);
    }

    @Override
    public void func_180434_a(BufferBuilder buffer, Entity viewer, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        Tessellator.func_178181_a().func_78381_a();
        super.func_180434_a(buffer, viewer, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
    }

    @Override
    protected boolean shouldApplyOriginOffset() {
        return false;
    }

    @Override
    protected void draw(Tessellator tessellator, double length, float partialTicks) {
        this.random.setSeed(this.seed);
        float scale = this.field_70544_f;
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179140_f();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        int i = 0;
        while ((double)((float)i + 1.0f) < length) {
            this.drawShearedBox(tessellator, 0.0, 0.0, length - (double)i, 0.0, 0.0, length - (double)i - 1.0, 0.02f * scale, this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
            i = (int)((float)i + 1.0f);
        }
        this.drawShearedBox(tessellator, 0.0, 0.0, length - (double)i, 0.0, 0.0, 0.0, 0.02f * scale, this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
        for (double l = length; l > 0.0; l -= 0.5) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)(this.random.nextInt(4) * 90), (float)0.0f, (float)0.0f, (float)1.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            TextureAtlasSprite leaf = Minecraft.func_71410_x().func_147117_R().func_110572_b(LEAF_TEXTURES[this.random.nextInt(LEAF_TEXTURES.length)].toString());
            float w = 0.32f * scale;
            float u1 = leaf.func_94209_e();
            float u2 = leaf.func_94212_f();
            float v1 = leaf.func_94206_g();
            float v2 = leaf.func_94210_h();
            float colourVariation = 0.3f;
            float r = MathHelper.func_76131_a((float)(this.field_70552_h + (this.random.nextFloat() - 0.5f) * colourVariation), (float)0.0f, (float)1.0f);
            float g = MathHelper.func_76131_a((float)(this.field_70553_i + (this.random.nextFloat() - 0.5f) * colourVariation), (float)0.0f, (float)1.0f);
            float b = MathHelper.func_76131_a((float)(this.field_70551_j + (this.random.nextFloat() - 0.5f) * colourVariation), (float)0.0f, (float)1.0f);
            buffer.func_181662_b(0.0, 0.0, l).func_187315_a((double)u1, (double)v1).func_181666_a(r, g, b, this.field_82339_as).func_181675_d();
            buffer.func_181662_b((double)w, 0.0, l).func_187315_a((double)u2, (double)v1).func_181666_a(r, g, b, this.field_82339_as).func_181675_d();
            buffer.func_181662_b((double)w, (double)w, l).func_187315_a((double)u2, (double)v2).func_181666_a(r, g, b, this.field_82339_as).func_181675_d();
            buffer.func_181662_b(0.0, (double)w, l).func_187315_a((double)u1, (double)v2).func_181666_a(r, g, b, this.field_82339_as).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
    }

    private void drawShearedBox(Tessellator tessellator, double x1, double y1, double z1, double x2, double y2, double z2, float width, float r, float g, float b, float a) {
        float u1 = this.field_187119_C.func_94209_e();
        float u2 = u1 + (this.field_187119_C.func_94212_f() - u1) * (float)(z1 - z2) / 1.0f;
        float v1 = this.field_187119_C.func_94206_g();
        float dv = this.field_187119_C.func_94210_h() - v1;
        float v2 = v1 + dv * 0.0625f;
        float v3 = v1 + dv * 0.125f;
        float v4 = v1 + dv * 0.1875f;
        float v5 = v1 + dv * 0.25f;
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b(x1 - (double)width, y1 - (double)width, z1).func_187315_a((double)u1, (double)v1).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x2 - (double)width, y2 - (double)width, z2).func_187315_a((double)u2, (double)v1).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x1 - (double)width, y1 + (double)width, z1).func_187315_a((double)u1, (double)v2).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x2 - (double)width, y2 + (double)width, z2).func_187315_a((double)u2, (double)v2).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x1 + (double)width, y1 + (double)width, z1).func_187315_a((double)u1, (double)v3).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x2 + (double)width, y2 + (double)width, z2).func_187315_a((double)u2, (double)v3).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x1 + (double)width, y1 - (double)width, z1).func_187315_a((double)u1, (double)v4).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x2 + (double)width, y2 - (double)width, z2).func_187315_a((double)u2, (double)v4).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x1 - (double)width, y1 - (double)width, z1).func_187315_a((double)u1, (double)v5).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x2 - (double)width, y2 - (double)width, z2).func_187315_a((double)u2, (double)v5).func_181666_a(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
    }

    @SubscribeEvent
    public static void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(STEM_TEXTURE);
        for (ResourceLocation texture : LEAF_TEXTURES) {
            event.getMap().func_174942_a(texture);
        }
    }
}

