/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.constants;

import electroblob.wizardry.Wizardry;
import javax.annotation.Nullable;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public enum Element implements IStringSerializable
{
    MAGIC(new Style().func_150238_a(TextFormatting.GRAY), "magic"),
    FIRE(new Style().func_150238_a(TextFormatting.DARK_RED), "fire"),
    ICE(new Style().func_150238_a(TextFormatting.AQUA), "ice"),
    LIGHTNING(new Style().func_150238_a(TextFormatting.DARK_AQUA), "lightning"),
    NECROMANCY(new Style().func_150238_a(TextFormatting.DARK_PURPLE), "necromancy"),
    EARTH(new Style().func_150238_a(TextFormatting.DARK_GREEN), "earth"),
    SORCERY(new Style().func_150238_a(TextFormatting.GREEN), "sorcery"),
    HEALING(new Style().func_150238_a(TextFormatting.YELLOW), "healing");

    private final Style colour;
    private final String unlocalisedName;
    private final ResourceLocation icon;

    private Element(Style colour, String name) {
        this(colour, name, "ebwizardry");
    }

    private Element(Style colour, String name, String modid) {
        this.colour = colour;
        this.unlocalisedName = name;
        this.icon = new ResourceLocation(modid, "textures/gui/container/element_icon_" + this.unlocalisedName + ".png");
    }

    public static Element fromName(String name) {
        for (Element element : Element.values()) {
            if (!element.unlocalisedName.equals(name)) continue;
            return element;
        }
        throw new IllegalArgumentException("No such element with unlocalised name: " + name);
    }

    @Nullable
    public static Element fromName(String name, @Nullable Element fallback) {
        for (Element element : Element.values()) {
            if (!element.unlocalisedName.equals(name)) continue;
            return element;
        }
        return fallback;
    }

    public String getDisplayName() {
        return Wizardry.proxy.translate("element." + this.func_176610_l(), new Object[0]);
    }

    public Style getColour() {
        return this.colour;
    }

    public String getFormattingCode() {
        return this.colour.func_150218_j();
    }

    public ITextComponent getWizardName() {
        return new TextComponentTranslation("element." + this.func_176610_l() + ".wizard", new Object[0]);
    }

    public String func_176610_l() {
        return this.unlocalisedName;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }
}

