/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.data;

import com.google.common.collect.EvictingQueue;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.IVariable;
import electroblob.wizardry.enchantment.Imbuement;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.packet.PacketCastContinuousSpell;
import electroblob.wizardry.packet.PacketPlayerSync;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.None;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.SpellModifiers;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class WizardData
implements INBTSerializable<NBTTagCompound> {
    @CapabilityInject(value=WizardData.class)
    private static final Capability<WizardData> WIZARD_DATA_CAPABILITY = null;
    private static final Set<IStoredVariable> storedVariables = new HashSet<IStoredVariable>();
    public static int MAX_RECENT_SPELLS;
    private static final int IMBUEMENT_UPDATE_INTERVAL = 20;
    private final EntityPlayer player;
    public final Random synchronisedRandom;
    private Spell castCommandSpell;
    private int castCommandTick;
    private SpellModifiers castCommandModifiers;
    private int castCommandDuration;
    public SpellModifiers itemCastingModifiers;
    public WeakReference<ISummonedCreature> selectedMinion;
    public Set<Spell> spellsDiscovered;
    private Tier maxTierReached = Tier.NOVICE;
    private Set<UUID> allies;
    public Set<String> allyNames;
    private final Map<IVariable, Object> spellData;
    private Queue<AbstractMap.SimpleEntry<Spell, Long>> recentSpells;
    private Map<Imbuement, Integer> imbuementDurations;
    public double prevMotionY;

    public WizardData() {
        this(null);
    }

    public WizardData(EntityPlayer player) {
        this.player = player;
        this.synchronisedRandom = new Random();
        this.imbuementDurations = new HashMap<Imbuement, Integer>();
        this.spellsDiscovered = new HashSet<Spell>();
        this.spellsDiscovered.add(Spells.magic_missile);
        this.recentSpells = EvictingQueue.create((int)MAX_RECENT_SPELLS);
        this.castCommandSpell = Spells.none;
        this.castCommandModifiers = new SpellModifiers();
        this.castCommandTick = 0;
        this.itemCastingModifiers = new SpellModifiers();
        this.allies = new HashSet<UUID>();
        this.allyNames = new HashSet<String>();
        this.spellData = new HashMap<IVariable, Object>();
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(WizardData.class, (Capability.IStorage)new Capability.IStorage<WizardData>(){

            public NBTBase writeNBT(Capability<WizardData> capability, WizardData instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<WizardData> capability, WizardData instance, EnumFacing side, NBTBase nbt) {
            }
        }, WizardData::new);
    }

    public static WizardData get(EntityPlayer player) {
        return (WizardData)player.getCapability(WIZARD_DATA_CAPABILITY, null);
    }

    public static void registerStoredVariables(IStoredVariable<?> ... variables) {
        storedVariables.addAll(Arrays.asList(variables));
    }

    public static Set<IVariable> getSyncedVariablesOrderedByKey() {
        Comparator<IVariable> keyComparator = Comparator.comparing(IVariable::getKey);
        return storedVariables.stream().filter(IVariable::isSynced).sorted(keyComparator).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public <T> void setVariable(IVariable<? super T> variable, T value) {
        this.spellData.put(variable, value);
    }

    @Nullable
    public <T> T getVariable(IVariable<T> variable) {
        return (T)this.spellData.get(variable);
    }

    public boolean hasSpellBeenDiscovered(Spell spell) {
        return this.spellsDiscovered.contains(spell) || spell instanceof None;
    }

    public boolean discoverSpell(Spell spell) {
        if (this.spellsDiscovered == null) {
            this.spellsDiscovered = new HashSet<Spell>();
        }
        if (spell instanceof None) {
            return false;
        }
        return this.spellsDiscovered.add(spell);
    }

    public void setTierReached(Tier tier) {
        if (!this.hasReachedTier(tier)) {
            this.maxTierReached = tier;
        }
    }

    public boolean hasReachedTier(Tier tier) {
        return tier.level >= this.maxTierReached.level;
    }

    public void trackRecentSpell(Spell spell) {
        this.recentSpells.add(new AbstractMap.SimpleEntry<Spell, Long>(spell, this.player.field_70170_p.func_82737_E()));
    }

    public int countRecentCasts(Spell spell) {
        long currentTime = this.player.field_70170_p.func_82737_E();
        return (int)this.recentSpells.stream().filter(entry -> entry.getKey() == spell && currentTime - (Long)entry.getValue() < (long)Wizardry.settings.recentSpellExpiryTime).count();
    }

    public void setImbuementDuration(Enchantment enchantment, int duration) {
        if (!(enchantment instanceof Imbuement)) {
            throw new IllegalArgumentException("Attempted to set an imbuement duration for something that isn't an Imbuement!");
        }
        this.imbuementDurations.put((Imbuement)enchantment, duration);
    }

    public int getImbuementDuration(Enchantment enchantment) {
        Integer i = this.imbuementDurations.get(enchantment);
        return i == null ? 0 : i;
    }

    private void updateImbuedItems() {
        HashSet<Imbuement> activeImbuements = new HashSet<Imbuement>();
        for (ItemStack stack : this.player.field_71071_by.field_70462_a) {
            this.updateImbutedItem(stack, activeImbuements);
        }
        for (ItemStack stack : this.player.field_71071_by.field_70460_b) {
            this.updateImbutedItem(stack, activeImbuements);
        }
        for (ItemStack stack : this.player.field_71071_by.field_184439_c) {
            this.updateImbutedItem(stack, activeImbuements);
        }
        this.imbuementDurations.keySet().retainAll(activeImbuements);
    }

    private void updateImbutedItem(ItemStack stack, Set<Imbuement> activeImbuements) {
        if (stack.func_77948_v()) {
            NBTTagList enchantmentList = stack.func_77973_b() == Items.field_151134_bR ? ItemEnchantedBook.func_92110_g((ItemStack)stack) : stack.func_77986_q();
            Iterator iterator = enchantmentList.iterator();
            while (iterator.hasNext()) {
                NBTTagCompound enchantmentTag = (NBTTagCompound)iterator.next();
                Enchantment enchantment = Enchantment.func_185262_c((int)enchantmentTag.func_74765_d("id"));
                if (!(enchantment instanceof Imbuement)) continue;
                int duration = this.getImbuementDuration(enchantment);
                if (duration > 0) {
                    this.imbuementDurations.put((Imbuement)enchantment, duration - 20);
                    activeImbuements.add((Imbuement)enchantment);
                    continue;
                }
                ((Imbuement)enchantment).onImbuementRemoval(stack);
                iterator.remove();
            }
        }
    }

    public boolean toggleAlly(EntityPlayer player) {
        if (this.isPlayerAlly(player)) {
            this.allies.remove(player.func_110124_au());
            this.allyNames.remove(player.func_70005_c_());
            return false;
        }
        this.allies.add(player.func_110124_au());
        this.allyNames.add(player.func_70005_c_());
        return true;
    }

    public boolean isPlayerAlly(EntityPlayer player) {
        return this.allies.contains(player.func_110124_au()) || this.player.func_184191_r((Entity)player);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPlayerAlly(UUID playerUUID) {
        if (this.allies.contains(playerUUID)) return true;
        if (this.player.func_96124_cp() == null) return false;
        if (this.player.func_96124_cp().func_96670_d() == null) return false;
        if (!this.player.func_96124_cp().func_96670_d().stream().anyMatch(this.allyNames::contains)) return false;
        return true;
    }

    public void startCastingContinuousSpell(Spell spell, SpellModifiers modifiers, int duration) {
        this.castCommandSpell = spell;
        this.castCommandModifiers = modifiers;
        this.castCommandDuration = duration;
        if (!this.player.field_70170_p.field_72995_K) {
            PacketCastContinuousSpell.Message message = new PacketCastContinuousSpell.Message(this.player, spell, modifiers, duration);
            WizardryPacketHandler.net.sendToDimension((IMessage)message, this.player.field_70170_p.field_73011_w.getDimension());
        }
    }

    public void stopCastingContinuousSpell() {
        this.castCommandSpell = Spells.none;
        this.castCommandTick = 0;
        this.castCommandModifiers.reset();
        if (!this.player.field_70170_p.field_72995_K) {
            PacketCastContinuousSpell.Message message = new PacketCastContinuousSpell.Message(this.player, Spells.none, this.castCommandModifiers, this.castCommandDuration);
            WizardryPacketHandler.net.sendToDimension((IMessage)message, this.player.field_70170_p.field_73011_w.getDimension());
        }
    }

    public void updateContinuousSpellCasting() {
        if (this.castCommandSpell != null && this.castCommandSpell.isContinuous) {
            if (this.castCommandTick >= this.castCommandDuration) {
                this.stopCastingContinuousSpell();
                return;
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(SpellCastEvent.Source.COMMAND, this.castCommandSpell, (EntityLivingBase)this.player, this.castCommandModifiers, this.castCommandTick))) {
                this.stopCastingContinuousSpell();
                return;
            }
            if (this.castCommandSpell.cast(this.player.field_70170_p, this.player, EnumHand.MAIN_HAND, this.castCommandTick, this.castCommandModifiers) && this.castCommandTick == 0) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.COMMAND, this.castCommandSpell, (EntityLivingBase)this.player, this.castCommandModifiers));
            }
            ++this.castCommandTick;
        } else {
            this.castCommandTick = 0;
        }
    }

    public boolean isCasting() {
        return this.castCommandSpell != null && this.castCommandSpell != Spells.none;
    }

    public Spell currentlyCasting() {
        return this.castCommandSpell;
    }

    private void update() {
        if (this.selectedMinion != null && this.selectedMinion.get() == null) {
            this.selectedMinion = null;
        }
        this.prevMotionY = this.player.field_70181_x;
        if (this.player.field_70173_aa % 20 == 0) {
            this.updateImbuedItems();
        }
        this.updateContinuousSpellCasting();
        if (this.player.field_70173_aa % 60 == 0) {
            long currentTime = this.player.field_70170_p.func_82737_E();
            this.recentSpells.removeIf(entry -> currentTime - (Long)entry.getValue() >= (long)Wizardry.settings.recentSpellExpiryTime);
        }
        this.spellData.forEach((k, v) -> this.spellData.put((IVariable)k, k.update(this.player, v)));
        this.spellData.keySet().removeIf(k -> k.canPurge(this.player, this.spellData.get(k)));
    }

    public void copyFrom(WizardData data, boolean respawn) {
        this.allies = data.allies;
        this.allyNames = data.allyNames;
        this.selectedMinion = data.selectedMinion;
        this.spellsDiscovered = data.spellsDiscovered;
        this.maxTierReached = data.maxTierReached;
        this.recentSpells = data.recentSpells;
        for (IVariable variable : data.spellData.keySet()) {
            if (!variable.isPersistent(respawn)) continue;
            this.spellData.put(variable, data.spellData.get(variable));
        }
    }

    public void sync() {
        if (this.player instanceof EntityPlayerMP) {
            int id = -1;
            if (this.selectedMinion != null && this.selectedMinion.get() instanceof Entity) {
                id = ((Entity)this.selectedMinion.get()).func_145782_y();
            }
            long seed = this.player.field_70170_p.field_73012_v.nextLong();
            this.synchronisedRandom.setSeed(seed);
            PacketPlayerSync.Message msg = new PacketPlayerSync.Message(seed, this.spellsDiscovered, id, this.spellData);
            WizardryPacketHandler.net.sendTo((IMessage)msg, (EntityPlayerMP)this.player);
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound properties = new NBTTagCompound();
        NBTExtras.storeTagSafely(properties, "imbuements", (NBTBase)NBTExtras.mapToNBT(this.imbuementDurations, imbuement -> new NBTTagInt(Enchantment.func_185258_b((Enchantment)((Enchantment)imbuement))), NBTTagInt::new));
        NBTExtras.storeTagSafely(properties, "allies", (NBTBase)NBTExtras.listToNBT(this.allies, NBTUtil::func_186862_a));
        NBTExtras.storeTagSafely(properties, "allyNames", (NBTBase)NBTExtras.listToNBT(this.allyNames, NBTTagString::new));
        int[] spells = new int[this.spellsDiscovered.size()];
        int i = 0;
        for (Spell spell : this.spellsDiscovered) {
            spells[i] = spell.metadata();
            ++i;
        }
        properties.func_74783_a("discoveredSpells", spells);
        properties.func_74768_a("maxTierReached", this.maxTierReached.ordinal());
        NBTTagList recentSpellsList = new NBTTagList();
        for (AbstractMap.SimpleEntry simpleEntry : this.recentSpells) {
            NBTTagCompound spellTag = new NBTTagCompound();
            spellTag.func_74768_a("spellId", ((Spell)simpleEntry.getKey()).metadata());
            spellTag.func_74772_a("timestamp", ((Long)simpleEntry.getValue()).longValue());
            recentSpellsList.func_74742_a((NBTBase)spellTag);
        }
        NBTExtras.storeTagSafely(properties, "recentSpells", (NBTBase)recentSpellsList);
        storedVariables.forEach(k -> k.write(properties, this.spellData.get(k)));
        return properties;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            this.imbuementDurations = NBTExtras.NBTToMap(nbt.func_150295_c("imbuements", 10), tag -> (Imbuement)Enchantment.func_185262_c((int)tag.func_150287_d()), NBTTagInt::func_150287_d);
            this.allies = new HashSet<UUID>(NBTExtras.NBTToList(nbt.func_150295_c("allies", 10), NBTUtil::func_186860_b));
            this.allyNames = new HashSet<String>(NBTExtras.NBTToList(nbt.func_150295_c("allyNames", 8), NBTTagString::func_150285_a_));
            this.spellsDiscovered = new HashSet<Spell>();
            for (int id : nbt.func_74759_k("discoveredSpells")) {
                this.spellsDiscovered.add(Spell.byMetadata(id));
            }
            this.maxTierReached = Tier.values()[nbt.func_74762_e("maxTierReached")];
            this.recentSpells = EvictingQueue.create((int)MAX_RECENT_SPELLS);
            NBTTagList recentSpellsList = nbt.func_150295_c("recentSpells", 10);
            for (int i = 0; i < recentSpellsList.func_74745_c(); ++i) {
                NBTTagCompound spellTag = recentSpellsList.func_150305_b(i);
                Spell spell = Spell.byMetadata(spellTag.func_74762_e("spellId"));
                long timestamp = spellTag.func_74763_f("timestamp");
                this.recentSpells.add(new AbstractMap.SimpleEntry<Spell, Long>(spell, timestamp));
            }
            try {
                storedVariables.forEach(k -> this.spellData.put((IVariable)k, k.read(nbt)));
            }
            catch (ClassCastException e) {
                Wizardry.logger.error("Wizard data NBT tag was not of expected type!", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public static void onCapabilityLoad(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("ebwizardry", "WizardData"), (ICapabilityProvider)new Provider((EntityPlayer)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onPlayerCloneEvent(PlayerEvent.Clone event) {
        WizardData newData = WizardData.get(event.getEntityPlayer());
        WizardData oldData = WizardData.get(event.getOriginal());
        newData.copyFrom(oldData, event.isWasDeath());
        newData.sync();
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        WizardData data;
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayerMP && (data = WizardData.get((EntityPlayer)event.getEntity())) != null) {
            data.sync();
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && WizardData.get(player = (EntityPlayer)event.getEntityLiving()) != null) {
            WizardData.get(player).update();
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final WizardData data;

        public Provider(EntityPlayer player) {
            this.data = new WizardData(player);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == WIZARD_DATA_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == WIZARD_DATA_CAPABILITY) {
                return (T)WIZARD_DATA_CAPABILITY.cast((Object)this.data);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return this.data.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.data.deserializeNBT(nbt);
        }
    }
}

