/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.construct;

import electroblob.wizardry.entity.construct.EntityScaledConstruct;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityBlizzard
extends EntityScaledConstruct {
    public EntityBlizzard(World world) {
        super(world);
        this.func_70105_a(Spells.blizzard.getProperty("effect_radius").floatValue() * 2.0f, 3.0f);
    }

    @Override
    protected boolean shouldScaleHeight() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70173_aa % 120 == 1) {
            this.func_184185_a(WizardrySounds.ENTITY_BLIZZARD_AMBIENT, 1.0f, 1.0f);
        }
        super.func_70071_h_();
        double radius = Spells.blizzard.getProperty("effect_radius").doubleValue() * (double)this.sizeMultiplier;
        if (!this.field_70170_p.field_72995_K) {
            List<EntityLivingBase> targets = EntityUtils.getLivingWithinRadius(radius, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p);
            for (EntityLivingBase target : targets) {
                if (this.isValidTarget((Entity)target)) {
                    if (this.getCaster() != null) {
                        EntityUtils.attackEntityWithoutKnockback((Entity)target, MagicDamage.causeIndirectMagicDamage(this, (Entity)this.getCaster(), MagicDamage.DamageType.FROST), 1.0f * this.damageMultiplier);
                    } else {
                        EntityUtils.attackEntityWithoutKnockback((Entity)target, DamageSource.field_76376_m, 1.0f * this.damageMultiplier);
                    }
                }
                if (MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)target)) continue;
                target.func_70690_d(new PotionEffect(WizardryPotions.frost, 20, 0));
            }
        } else {
            double speed;
            int i;
            for (i = 0; i < 6; ++i) {
                speed = (double)(this.field_70146_Z.nextBoolean() ? 1 : -1) * (0.1 + 0.05 * this.field_70146_Z.nextDouble());
                ParticleBuilder.create(ParticleBuilder.Type.SNOW).pos(this.field_70165_t, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v).vel(0.0, 0.0, 0.0).time(100).scale(2.0f).spin(this.field_70146_Z.nextDouble() * (radius - 0.5) + 0.5, speed).shaded(true).spawn(this.field_70170_p);
            }
            for (i = 0; i < 3; ++i) {
                speed = (double)(this.field_70146_Z.nextBoolean() ? 1 : -1) * (0.05 + 0.02 * this.field_70146_Z.nextDouble());
                ParticleBuilder.create(ParticleBuilder.Type.CLOUD).pos(this.field_70165_t, this.field_70163_u + this.field_70146_Z.nextDouble() * ((double)this.field_70131_O - 0.5), this.field_70161_v).clr(0xFFFFFF).shaded(true).spin(this.field_70146_Z.nextDouble() * (radius - 1.0) + 0.5, speed).spawn(this.field_70170_p);
            }
        }
    }
}

