/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.construct;

import electroblob.wizardry.entity.construct.EntityScaledConstruct;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityFireRing
extends EntityScaledConstruct {
    public EntityFireRing(World world) {
        super(world);
        this.func_70105_a(Spells.ring_of_fire.getProperty("effect_radius").floatValue() * 2.0f, 1.0f);
    }

    @Override
    protected boolean shouldScaleHeight() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70173_aa % 40 == 1) {
            this.func_184185_a(WizardrySounds.ENTITY_FIRE_RING_AMBIENT, 4.0f, 0.7f);
        }
        super.func_70071_h_();
        if (this.field_70173_aa % 5 == 0 && !this.field_70170_p.field_72995_K) {
            List<EntityLivingBase> targets = EntityUtils.getLivingWithinCylinder(this.field_70130_N / 2.0f, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70131_O, this.field_70170_p);
            for (EntityLivingBase target : targets) {
                if (!this.isValidTarget((Entity)target)) continue;
                double velX = target.field_70159_w;
                double velY = target.field_70181_x;
                double velZ = target.field_70179_y;
                if (!MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, (Entity)target)) {
                    target.func_70015_d(Spells.ring_of_fire.getProperty("burn_duration").intValue());
                    float damage = Spells.ring_of_fire.getProperty("damage").floatValue() * this.damageMultiplier;
                    if (this.getCaster() != null) {
                        target.func_70097_a(MagicDamage.causeIndirectMagicDamage(this, (Entity)this.getCaster(), MagicDamage.DamageType.FIRE), damage);
                    } else {
                        target.func_70097_a(DamageSource.field_76376_m, damage);
                    }
                }
                target.field_70159_w = velX;
                target.field_70181_x = velY;
                target.field_70179_y = velZ;
            }
        }
    }
}

