/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.projectile;

import electroblob.wizardry.entity.projectile.EntityMagicArrow;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.ParticleBuilder;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityFlamecatcherArrow
extends EntityMagicArrow {
    public static final float SPEED = 3.0f;

    public EntityFlamecatcherArrow(World world) {
        super(world);
    }

    @Override
    public double getDamage() {
        return Spells.flamecatcher.getProperty("damage").floatValue();
    }

    @Override
    public int getLifetime() {
        return (int)(Spells.flamecatcher.getProperty("range").floatValue() / 3.0f);
    }

    @Override
    public boolean doGravity() {
        return false;
    }

    @Override
    public boolean doDeceleration() {
        return false;
    }

    @Override
    public void onEntityHit(EntityLivingBase entityHit) {
        entityHit.func_70015_d(Spells.flamecatcher.getProperty("burn_duration").intValue());
        this.func_184185_a(WizardrySounds.ENTITY_FLAMECATCHER_ARROW_HIT, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        if (this.field_70170_p.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(this.field_70165_t, this.field_70163_u, this.field_70161_v).clr(16739584).spawn(this.field_70170_p);
        }
    }

    @Override
    public void onBlockHit(RayTraceResult hit) {
        if (this.field_70170_p.field_72995_K) {
            Vec3d vec = hit.field_72307_f.func_178787_e(new Vec3d(hit.field_178784_b.func_176730_m()).func_186678_a(0.15));
            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(vec).clr(16739584).fade(0.85f, 0.5f, 0.8f).spawn(this.field_70170_p);
        }
    }

    @Override
    public void tickInAir() {
        if (this.field_70170_p.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.MAGIC_FIRE, this.field_70146_Z, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.03, false).time(20 + this.field_70146_Z.nextInt(10)).spawn(this.field_70170_p);
            if (this.field_70173_aa > 1) {
                double x = this.field_70165_t - this.field_70159_w / 2.0;
                double y = this.field_70163_u - this.field_70181_x / 2.0;
                double z = this.field_70161_v - this.field_70179_y / 2.0;
                ParticleBuilder.create(ParticleBuilder.Type.MAGIC_FIRE, this.field_70146_Z, x, y, z, 0.03, false).time(20 + this.field_70146_Z.nextInt(10)).spawn(this.field_70170_p);
            }
        }
    }

    @Override
    protected void func_70088_a() {
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.FLASH).entity(this).time(this.getLifetime()).scale(1.5f).clr(16758784).spawn(this.field_70170_p);
        }
    }
}

