/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.projectile;

import electroblob.wizardry.entity.projectile.EntityMagicArrow;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityIceLance
extends EntityMagicArrow {
    public EntityIceLance(World world) {
        super(world);
        this.setKnockbackStrength(1);
    }

    @Override
    public double getDamage() {
        return Spells.ice_lance.getProperty("damage").floatValue();
    }

    @Override
    public int getLifetime() {
        return -1;
    }

    @Override
    public MagicDamage.DamageType getDamageType() {
        return MagicDamage.DamageType.FROST;
    }

    @Override
    public boolean doGravity() {
        return true;
    }

    @Override
    public boolean doDeceleration() {
        return true;
    }

    @Override
    public boolean doOverpenetration() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    @Override
    public void onEntityHit(EntityLivingBase entityHit) {
        if (!MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)entityHit)) {
            entityHit.func_70690_d(new PotionEffect(WizardryPotions.frost, Spells.ice_lance.getProperty("effect_duration").intValue(), Spells.ice_lance.getProperty("effect_strength").intValue()));
        }
        this.func_184185_a(WizardrySounds.ENTITY_ICE_LANCE_HIT, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
    }

    @Override
    public void onBlockHit(RayTraceResult hit) {
        if (this.field_70170_p.field_72995_K) {
            for (int j = 0; j < 10; ++j) {
                ParticleBuilder.create(ParticleBuilder.Type.ICE, this.field_70146_Z, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.5, true).time(20 + this.field_70146_Z.nextInt(10)).gravity(true).spawn(this.field_70170_p);
            }
        }
        this.func_184185_a(WizardrySounds.ENTITY_ICE_LANCE_SMASH, 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 1.2f);
    }

    @Override
    protected void func_70088_a() {
    }
}

