/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.integration.jei;

import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.constants.Constants;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.inventory.ContainerArcaneWorkbench;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.registry.WizardryItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class ArcaneWorkbenchRecipe
implements IRecipeWrapper {
    private final ItemStack centreStack;
    private final List<ItemStack> books;
    private final List<ItemStack> crystals;
    private final List<ItemStack> upgrades;
    private final ItemStack result;
    private final int bookSlots;
    private final List<List<ItemStack>> inputs;

    public ArcaneWorkbenchRecipe(ItemStack centreStack, List<ItemStack> books, List<ItemStack> crystals, List<ItemStack> upgrades, ItemStack result) {
        this.centreStack = centreStack;
        this.books = books;
        this.crystals = crystals;
        this.upgrades = upgrades;
        this.result = result;
        this.inputs = new ArrayList<List<ItemStack>>();
        for (ItemStack book : books) {
            this.inputs.add(Collections.singletonList(book));
        }
        this.inputs.add(crystals);
        this.inputs.add(Collections.singletonList(centreStack));
        this.inputs.add(upgrades);
        this.bookSlots = centreStack.func_77973_b() instanceof IWorkbenchItem ? ((IWorkbenchItem)centreStack.func_77973_b()).getSpellSlotCount(centreStack) : 0;
    }

    public ArcaneWorkbenchRecipe(ItemStack centreStack, List<ItemStack> books, int mana, List<ItemStack> upgrades, ItemStack result) {
        this(centreStack, books, ArcaneWorkbenchRecipe.generateCrystalStacks(mana), upgrades, result);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.result);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        for (int i = 0; i < this.bookSlots; ++i) {
            int x = 74 + ContainerArcaneWorkbench.getBookSlotXOffset(i, this.bookSlots) - 9;
            int y = 54 + ContainerArcaneWorkbench.getBookSlotYOffset(i, this.bookSlots) - 9;
            DrawingUtils.drawTexturedRect(x, y, 0, 126, 36, 36, 256, 256);
        }
    }

    public static List<ItemStack> generateCrystalStacks(int mana) {
        if (mana < 0) {
            throw new IllegalArgumentException("Cannot create an arcane workbench recipe with negative mana!");
        }
        if (mana == 0) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> crystalStacks = new ArrayList<ItemStack>();
        int count = MathHelper.func_76123_f((float)((float)mana / (float)Constants.MANA_PER_CRYSTAL));
        if (count <= WizardryItems.magic_crystal.getItemStackLimit(ItemStack.field_190927_a)) {
            for (int meta = 0; meta < Element.values().length; ++meta) {
                crystalStacks.add(new ItemStack(WizardryItems.magic_crystal, count, meta));
            }
        }
        if ((count = MathHelper.func_76123_f((float)((float)mana / (float)Constants.MANA_PER_SHARD))) <= WizardryItems.crystal_shard.getItemStackLimit(ItemStack.field_190927_a)) {
            crystalStacks.add(new ItemStack(WizardryItems.crystal_shard, count));
        }
        if ((count = MathHelper.func_76123_f((float)((float)mana / (float)Constants.GRAND_CRYSTAL_MANA))) <= WizardryItems.grand_crystal.getItemStackLimit(ItemStack.field_190927_a)) {
            crystalStacks.add(new ItemStack(WizardryItems.grand_crystal, count));
        }
        return crystalStacks;
    }
}

