/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Constants;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryTabs;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellProperties;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class ItemBlankScroll
extends Item
implements IWorkbenchItem {
    public ItemBlankScroll() {
        this.func_77637_a(WizardryTabs.WIZARDRY);
        this.func_185043_a(new ResourceLocation("festive"), (s, w, e) -> Wizardry.tisTheSeason ? 1.0f : 0.0f);
    }

    @Override
    public int getSpellSlotCount(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean showTooltip(ItemStack stack) {
        return false;
    }

    @Override
    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        if (!spellBooks[0].func_75211_c().func_190926_b() && !crystals.func_75211_c().func_190926_b()) {
            Spell spell = Spell.byMetadata(spellBooks[0].func_75211_c().func_77952_i());
            WizardData data = WizardData.get(player);
            if (spell != Spells.none && player.func_184812_l_() || data != null && data.hasSpellBeenDiscovered(spell) && spell.isEnabled(SpellProperties.Context.SCROLL)) {
                int cost = spell.getCost() * centre.func_75211_c().func_190916_E();
                if (spell.isContinuous) {
                    cost *= 6;
                }
                int manaPerItem = Constants.MANA_PER_CRYSTAL;
                if (crystals.func_75211_c().func_77973_b() == WizardryItems.crystal_shard) {
                    manaPerItem = Constants.MANA_PER_SHARD;
                }
                if (crystals.func_75211_c().func_77973_b() == WizardryItems.grand_crystal) {
                    manaPerItem = Constants.GRAND_CRYSTAL_MANA;
                }
                if (crystals.func_75211_c().func_190916_E() * manaPerItem > cost) {
                    crystals.func_75209_a(MathHelper.func_76123_f((float)((float)cost / (float)manaPerItem)));
                    centre.func_75215_d(new ItemStack(WizardryItems.scroll, centre.func_75211_c().func_190916_E(), spell.metadata()));
                    return true;
                }
            }
        }
        return false;
    }
}

