/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.packet;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketNPCCastSpell
implements IMessageHandler<Message, IMessage> {
    public IMessage onMessage(final Message message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Wizardry.proxy.handleNPCCastSpellPacket(message);
                }
            });
        }
        return null;
    }

    public static class Message
    implements IMessage {
        public int casterID;
        public int targetID;
        public int spellID;
        public SpellModifiers modifiers;
        public EnumHand hand;

        public Message() {
        }

        public Message(int casterID, int targetID, EnumHand hand, Spell spell, SpellModifiers modifiers) {
            this.casterID = casterID;
            this.targetID = targetID;
            this.spellID = spell.networkID();
            this.modifiers = modifiers;
            this.hand = hand == null ? EnumHand.MAIN_HAND : hand;
        }

        public void fromBytes(ByteBuf buf) {
            this.casterID = buf.readInt();
            this.targetID = buf.readInt();
            this.spellID = buf.readInt();
            this.modifiers = new SpellModifiers();
            this.modifiers.read(buf);
            this.hand = buf.readBoolean() ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.casterID);
            buf.writeInt(this.targetID);
            buf.writeInt(this.spellID);
            this.modifiers.write(buf);
            buf.writeBoolean(this.hand == EnumHand.OFF_HAND);
        }
    }
}

