/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class CelestialSmite
extends SpellRay {
    public CelestialSmite() {
        super("celestial_smite", SpellActions.POINT, false);
        this.addProperties("effect_radius", "damage", "burn_duration");
        this.ignoreLivingEntities(true);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        double radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        List<EntityLivingBase> targets = EntityUtils.getLivingWithinRadius(radius, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, world);
        DamageSource source = caster == null ? DamageSource.field_76376_m : MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.RADIANT);
        float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
        for (EntityLivingBase target : targets) {
            EntityUtils.attackEntityWithoutKnockback((Entity)target, source, damage);
            target.func_70015_d(this.getProperty("burn_duration").intValue());
        }
        if (world.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.BEAM).pos(hit.field_72450_a, world.func_72940_L(), hit.field_72449_c).target(hit).scale(8.0f).clr(0xFFBF00).time(10).spawn(world);
            ParticleBuilder.create(ParticleBuilder.Type.SPHERE).pos(hit).scale(4.0f).clr(16773272).spawn(world);
            if (side == EnumFacing.UP) {
                Vec3d vec = hit.func_178787_e(new Vec3d(side.func_176730_m()).func_186678_a(0.005));
                ParticleBuilder.create(ParticleBuilder.Type.SCORCH).pos(vec).face(side).scale(3.0f).spawn(world);
            }
        }
        return true;
    }

    @Override
    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }
}

