/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.block.BlockStatue;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.SpellAreaEffect;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class IceAge
extends SpellAreaEffect {
    public static final String FREEZE_DURATION = "freeze_duration";

    public IceAge() {
        super("ice_age", SpellActions.POINT_DOWN, false);
        this.soundValues(1.5f, 1.0f, 0.0f);
        this.alwaysSucceed(true);
        this.addProperties(FREEZE_DURATION, "effect_duration", "effect_strength");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        this.freezeNearbyBlocks(world, caster.func_174791_d(), (EntityLivingBase)caster, modifiers);
        return super.cast(world, caster, hand, ticksInUse, modifiers);
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        this.freezeNearbyBlocks(world, caster.func_174791_d(), (EntityLivingBase)caster, modifiers);
        return super.cast(world, caster, hand, ticksInUse, target, modifiers);
    }

    @Override
    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        this.freezeNearbyBlocks(world, new Vec3d(x, y, z), null, modifiers);
        return super.cast(world, x, y, z, direction, ticksInUse, duration, modifiers);
    }

    @Override
    protected boolean affectEntity(World world, Vec3d origin, @Nullable EntityLivingBase caster, EntityLivingBase target, int targetCount, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityLiving) {
            if (((BlockStatue)WizardryBlocks.ice_statue).convertToStatue((EntityLiving)target, caster, (int)(this.getProperty(FREEZE_DURATION).floatValue() * modifiers.get(WizardryItems.duration_upgrade)))) {
                target.func_184185_a(WizardrySounds.MISC_FREEZE, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
            }
        } else if (target instanceof EntityPlayer) {
            target.func_70690_d(new PotionEffect(WizardryPotions.frost, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), this.getProperty("effect_strength").intValue()));
        }
        return true;
    }

    @Override
    protected void spawnParticleEffect(World world, Vec3d origin, double radius, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        double speed;
        float r;
        int i;
        for (i = 0; i < 100; ++i) {
            r = world.field_73012_v.nextFloat();
            speed = 0.02 / (double)r * (1.0 + world.field_73012_v.nextDouble());
            ParticleBuilder.create(ParticleBuilder.Type.SNOW).pos(origin.field_72450_a, origin.field_72448_b + world.field_73012_v.nextDouble() * 3.0, origin.field_72449_c).vel(0.0, 0.0, 0.0).scale(2.0f).spin(world.field_73012_v.nextDouble() * (radius - 0.5) + 0.5, speed).shaded(true).spawn(world);
        }
        for (i = 0; i < 60; ++i) {
            r = world.field_73012_v.nextFloat();
            speed = 0.02 / (double)r * (1.0 + world.field_73012_v.nextDouble());
            ParticleBuilder.create(ParticleBuilder.Type.CLOUD).pos(origin.field_72450_a, origin.field_72448_b + world.field_73012_v.nextDouble() * 2.5, origin.field_72449_c).clr(0xFFFFFF).spin(world.field_73012_v.nextDouble() * (radius - 1.0) + 0.5, speed).shaded(true).spawn(world);
        }
    }

    private void freezeNearbyBlocks(World world, Vec3d origin, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        if (!world.field_72995_K && EntityUtils.canDamageBlocks((Entity)caster, world)) {
            double radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
            for (int i = -((int)radius); i <= (int)radius; ++i) {
                for (int j = -((int)radius); j <= (int)radius; ++j) {
                    BlockPos pos = new BlockPos(origin).func_177982_a(i, 0, j);
                    Integer y = BlockUtils.getNearestSurface(world, new BlockPos((Vec3i)pos), EnumFacing.UP, (int)radius, true, BlockUtils.SurfaceCriteria.SOLID_LIQUID_TO_AIR);
                    if (y == null) continue;
                    pos = new BlockPos(pos.func_177958_n(), y.intValue(), pos.func_177952_p());
                    double dist = origin.func_72438_d(new Vec3d(origin.field_72450_a + (double)i, (double)y.intValue(), origin.field_72449_c + (double)j));
                    if (y == -1 || !((double)world.field_73012_v.nextInt((int)(dist * 2.0) + 1) < radius) || !(dist < radius) || !BlockUtils.canPlaceBlock((Entity)caster, world, pos)) continue;
                    BlockUtils.freeze(world, pos.func_177977_b(), true);
                }
            }
        }
    }
}

