/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class LightningRay
extends SpellRay {
    public LightningRay() {
        super("lightning_ray", SpellActions.POINT, true);
        this.aimAssist(0.6f);
        this.addProperties("damage");
    }

    @Override
    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    @Override
    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    @Override
    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving(target)) {
            if (MagicDamage.isEntityImmune(MagicDamage.DamageType.SHOCK, target)) {
                if (!world.field_72995_K && ticksInUse == 1 && caster instanceof EntityPlayer) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
                }
            } else if (ticksInUse % 10 == 0) {
                EntityUtils.attackEntityWithoutKnockback(target, MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.SHOCK), this.getProperty("damage").floatValue() * modifiers.get("potency"));
            }
            if (world.field_72995_K) {
                if (ticksInUse % 3 == 0) {
                    ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).entity((Entity)caster).pos(caster != null ? origin.func_178788_d(caster.func_174791_d()) : origin).target(target).spawn(world);
                }
                for (int i = 0; i < 5; ++i) {
                    ParticleBuilder.create(ParticleBuilder.Type.SPARK, target).spawn(world);
                }
            }
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        if (world.field_72995_K && ticksInUse % 4 == 0) {
            double freeRange = 0.8 * this.getRange(world, origin, direction, caster, ticksInUse, modifiers);
            if (caster != null) {
                ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).entity((Entity)caster).pos(origin.func_178788_d(caster.func_174791_d())).length(freeRange).spawn(world);
            } else {
                ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).pos(origin).target(origin.func_178787_e(direction.func_186678_a(freeRange))).spawn(world);
            }
        }
        return true;
    }
}

