/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Constants;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Permafrost
extends SpellRay {
    public Permafrost() {
        super("permafrost", SpellActions.POINT, true);
        this.particleVelocity(1.0);
        this.particleSpacing(0.5);
        this.soundValues(0.5f, 1.0f, 0.0f);
        this.addProperties("duration", "damage", "effect_duration", "effect_strength");
        this.ignoreLivingEntities(true);
    }

    @Override
    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    @Override
    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    @Override
    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        boolean flag = false;
        if (!world.field_72995_K) {
            int blastUpgradeCount = (int)((modifiers.get(WizardryItems.blast_upgrade) - 1.0f) / Constants.BLAST_RADIUS_INCREASE_PER_LEVEL + 0.5f);
            float radius = 0.5f + 0.73f * (float)blastUpgradeCount;
            int duration = (int)(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
            List<BlockPos> sphere = BlockUtils.getBlockSphere(pos.func_177984_a(), radius);
            for (BlockPos pos1 : sphere) {
                flag |= this.tryToPlaceIce(world, pos1, caster, duration);
            }
            return flag;
        }
        return true;
    }

    private boolean tryToPlaceIce(World world, BlockPos pos, EntityLivingBase caster, int duration) {
        if (world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && BlockUtils.canBlockBeReplaced(world, pos) && BlockUtils.canPlaceBlock((Entity)caster, world, pos)) {
            world.func_175656_a(pos, WizardryBlocks.permafrost.func_176223_P());
            world.func_175684_a(pos.func_185334_h(), WizardryBlocks.permafrost, duration);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        float brightness = world.field_73012_v.nextFloat();
        ParticleBuilder.create(ParticleBuilder.Type.DUST).pos(x, y, z).vel(vx, vy, vz).time(8 + world.field_73012_v.nextInt(12)).clr(0.4f + 0.6f * brightness, 0.6f + 0.4f * brightness, 1.0f).spawn(world);
        ParticleBuilder.create(ParticleBuilder.Type.SNOW).pos(x, y, z).vel(vx, vy, vz).time(8 + world.field_73012_v.nextInt(12)).spawn(world);
    }
}

