/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.Supplier;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ReplenishHunger
extends SpellBuff {
    public static final String HUNGER_POINTS = "hunger_points";
    public static final String SATURATION_MODIFIER = "saturation_modifier";

    public ReplenishHunger() {
        super("replenish_hunger", 1.0f, 0.7f, 0.3f, new Supplier[0]);
        this.soundValues(0.7f, 1.2f, 0.4f);
        this.addProperties(HUNGER_POINTS, SATURATION_MODIFIER);
    }

    @Override
    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    @Override
    protected boolean applyEffects(EntityLivingBase caster, SpellModifiers modifiers) {
        return true;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (caster.func_71024_bL().func_75121_c()) {
            int foodAmount = (int)(this.getProperty(HUNGER_POINTS).floatValue() * modifiers.get("potency"));
            caster.func_71024_bL().func_75122_a(foodAmount, this.getProperty(SATURATION_MODIFIER).floatValue());
            return super.cast(world, caster, hand, ticksInUse, modifiers);
        }
        return false;
    }
}

