/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.event.ResurrectionEvent;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.packet.PacketResurrection;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class Resurrection
extends Spell {
    public static final String WAIT_TIME = "wait_time";
    private static final String POTION_CORE_FIX_NBT_KEY = "Potion Core - Health Fix";

    public Resurrection() {
        super("resurrection", SpellActions.SUMMON, false);
        this.addProperties("effect_radius", WAIT_TIME);
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData data = WizardData.get(caster);
        double radius = this.getProperty("effect_radius").doubleValue() * (double)modifiers.get(WizardryItems.range_upgrade);
        if (!world.field_72995_K && caster.func_184102_h() != null) {
            int waitTime = (int)(this.getProperty(WAIT_TIME).floatValue() / modifiers.get("potency"));
            EntityPlayerMP nearestDeadAlly = caster.func_184102_h().func_184103_al().func_181057_v().stream().filter(p -> !p.func_70089_S() && p.field_70725_aQ > waitTime && (data.isPlayerAlly((EntityPlayer)p) || caster == p) && p.func_70068_e((Entity)caster) < radius * radius).min(Comparator.comparingDouble(arg_0 -> ((EntityPlayer)caster).func_70068_e(arg_0))).orElse(null);
            if (nearestDeadAlly != null) {
                if (MinecraftForge.EVENT_BUS.post((Event)new ResurrectionEvent((EntityPlayer)nearestDeadAlly, caster))) {
                    return false;
                }
                world.func_72900_e((Entity)nearestDeadAlly);
                this.resurrect((EntityPlayer)nearestDeadAlly);
                world.func_72838_d((Entity)nearestDeadAlly);
                PacketResurrection.Message msg = new PacketResurrection.Message(nearestDeadAlly.func_145782_y());
                WizardryPacketHandler.net.sendToDimension((IMessage)msg, caster.field_71093_bK);
                if (caster == nearestDeadAlly) {
                    caster.func_184102_h().func_184103_al().func_148539_a((ITextComponent)new TextComponentTranslation("spell." + this.getRegistryName() + ".resurrect_self", new Object[]{caster.func_145748_c_()}));
                } else {
                    caster.func_184102_h().func_184103_al().func_148539_a((ITextComponent)new TextComponentTranslation("spell." + this.getRegistryName() + ".resurrect_ally", new Object[]{nearestDeadAlly.func_145748_c_(), caster.func_145748_c_()}));
                }
                return true;
            }
        }
        return false;
    }

    public void resurrect(EntityPlayer player) {
        player.field_70128_L = false;
        player.func_70606_j(player.func_110138_aP() / 2.0f);
        player.field_70725_aQ = 0;
        player.field_71106_cc = 0.0f;
        player.field_71068_ca = 0;
        player.field_71067_cb = 0;
        player.getEntityData().func_82580_o(POTION_CORE_FIX_NBT_KEY);
        if (player.field_70170_p.field_72995_K) {
            ParticleBuilder.spawnHealParticles(player.field_70170_p, (EntityLivingBase)player);
            this.playSound(player.field_70170_p, (EntityLivingBase)player, 0, -1, null, new String[0]);
        }
    }

    public static int getRemainingWaitTime(int timeSinceDeath) {
        return Math.max(0, MathHelper.func_76123_f((float)((Spells.resurrection.getProperty(WAIT_TIME).floatValue() - (float)timeSinceDeath) / 20.0f)));
    }

    public static boolean canStackResurrect(ItemStack stack, EntityPlayer player) {
        return stack.func_77973_b() instanceof ISpellCastingItem && Arrays.asList(((ISpellCastingItem)stack.func_77973_b()).getSpells(stack)).contains(Spells.resurrection) && ((ISpellCastingItem)stack.func_77973_b()).canCast(stack, Spells.resurrection, player, EnumHand.MAIN_HAND, 0, new SpellModifiers());
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer firstPersonPlayer;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (player.field_70170_p.field_72995_K && !player.func_70089_S() && WizardData.get(firstPersonPlayer = Wizardry.proxy.getThePlayer()).isPlayerAlly(player)) {
                ItemStack wand = firstPersonPlayer.func_184614_ca();
                if (!(wand.func_77973_b() instanceof ISpellCastingItem) && !((wand = firstPersonPlayer.func_184592_cb()).func_77973_b() instanceof ISpellCastingItem)) {
                    return;
                }
                if (((ISpellCastingItem)wand.func_77973_b()).getCurrentSpell(wand) == Spells.resurrection) {
                    int waitTime = Spells.resurrection.getProperty(WAIT_TIME).intValue();
                    if (player.field_70725_aQ > waitTime) {
                        ParticleBuilder.create(ParticleBuilder.Type.SPARKLE, player.field_70170_p.field_73012_v, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, 0.5, false).clr(1.0f, 1.0f, 0.3f).vel(0.0, 0.02, 0.0).spawn(player.field_70170_p);
                    } else {
                        ParticleBuilder.create(ParticleBuilder.Type.DUST, player.field_70170_p.field_73012_v, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, 0.5, false).clr(1.0f, 1.0f, 0.3f).vel(0.0, 0.02, 0.0).time(50).spawn(player.field_70170_p);
                    }
                }
            }
        }
    }
}

