/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityTimer;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpectralPathway
extends Spell {
    public static final String LENGTH = "length";

    public SpectralPathway() {
        super("spectral_pathway", SpellActions.POINT, false);
        this.addProperties(LENGTH, "duration");
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (BlockUtils.getBlockEntityIsStandingOn((Entity)caster).func_177230_c() == Blocks.field_150350_a || BlockUtils.getBlockEntityIsStandingOn((Entity)caster).func_177230_c() == WizardryBlocks.spectral_block) {
            return false;
        }
        EnumFacing direction = caster.func_174811_aO();
        boolean flag = false;
        if (!world.field_72995_K) {
            BlockPos origin = new BlockPos((double)Math.round(caster.field_70165_t), (double)((int)caster.field_70163_u - 1), (double)Math.round(caster.field_70161_v));
            int startPoint = direction.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? -1 : 0;
            for (int i = 0; i < (int)(this.getProperty(LENGTH).floatValue() * modifiers.get(WizardryItems.range_upgrade)); ++i) {
                flag = this.placePathwayBlockIfPossible(world, origin.func_177967_a(direction, startPoint + i), modifiers.get(WizardryItems.duration_upgrade)) || flag;
                flag = this.placePathwayBlockIfPossible(world, origin.func_177967_a(direction, startPoint + i).func_177972_a(EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)direction.func_176746_e().func_176740_k())), modifiers.get(WizardryItems.duration_upgrade)) || flag;
            }
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return flag;
    }

    private boolean placePathwayBlockIfPossible(World world, BlockPos pos, float durationMultiplier) {
        if (BlockUtils.canBlockBeReplaced(world, pos, true)) {
            world.func_175656_a(pos, WizardryBlocks.spectral_block.func_176223_P());
            if (world.func_175625_s(pos) instanceof TileEntityTimer) {
                ((TileEntityTimer)world.func_175625_s(pos)).setLifetime((int)(this.getProperty("duration").floatValue() * durationMultiplier));
            }
            return true;
        }
        return false;
    }
}

