/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import electroblob.wizardry.constants.Constants;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemCrystal;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.NBTExtras;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class WandHelper {
    public static final String SPELL_ARRAY_KEY = "spells";
    public static final String SELECTED_SPELL_KEY = "selectedSpell";
    public static final String COOLDOWN_ARRAY_KEY = "cooldown";
    public static final String MAX_COOLDOWN_ARRAY_KEY = "maxCooldown";
    public static final String UPGRADES_KEY = "upgrades";
    public static final String PROGRESSION_KEY = "progression";
    private static final HashMap<Item, String> upgradeMap = new HashMap();

    public static Spell[] getSpells(ItemStack wand) {
        Spell[] spells = new Spell[]{};
        if (wand.func_77978_p() != null) {
            int[] spellIDs = wand.func_77978_p().func_74759_k(SPELL_ARRAY_KEY);
            spells = new Spell[spellIDs.length];
            for (int i = 0; i < spellIDs.length; ++i) {
                spells[i] = Spell.byMetadata(spellIDs[i]);
            }
        }
        return spells;
    }

    public static void setSpells(ItemStack wand, Spell[] spells) {
        if (wand.func_77978_p() == null) {
            wand.func_77982_d(new NBTTagCompound());
        }
        int[] spellIDs = new int[spells.length];
        for (int i = 0; i < spells.length; ++i) {
            spellIDs[i] = spells[i] != null ? spells[i].metadata() : Spells.none.metadata();
        }
        wand.func_77978_p().func_74783_a(SPELL_ARRAY_KEY, spellIDs);
    }

    public static Spell getCurrentSpell(ItemStack wand) {
        int selectedSpell;
        Spell[] spells = WandHelper.getSpells(wand);
        if (wand.func_77978_p() != null && (selectedSpell = wand.func_77978_p().func_74762_e(SELECTED_SPELL_KEY)) >= 0 && selectedSpell < spells.length) {
            return spells[selectedSpell];
        }
        return Spells.none;
    }

    public static Spell getNextSpell(ItemStack wand) {
        Spell[] spells = WandHelper.getSpells(wand);
        int index = WandHelper.getNextSpellIndex(wand);
        if (index >= 0 && index < spells.length) {
            return spells[index];
        }
        return Spells.none;
    }

    public static Spell getPreviousSpell(ItemStack wand) {
        Spell[] spells = WandHelper.getSpells(wand);
        int index = WandHelper.getPreviousSpellIndex(wand);
        if (index >= 0 && index < spells.length) {
            return spells[index];
        }
        return Spells.none;
    }

    public static void selectNextSpell(ItemStack wand) {
        if (WandHelper.getSpells(wand).length < 0) {
            WandHelper.setSpells(wand, new Spell[ItemWand.BASE_SPELL_SLOTS]);
        }
        if (wand.func_77978_p() != null) {
            wand.func_77978_p().func_74768_a(SELECTED_SPELL_KEY, WandHelper.getNextSpellIndex(wand));
        }
    }

    public static void selectPreviousSpell(ItemStack wand) {
        if (WandHelper.getSpells(wand).length < 0) {
            WandHelper.setSpells(wand, new Spell[ItemWand.BASE_SPELL_SLOTS]);
        }
        if (wand.func_77978_p() != null) {
            wand.func_77978_p().func_74768_a(SELECTED_SPELL_KEY, WandHelper.getPreviousSpellIndex(wand));
        }
    }

    public static boolean selectSpell(ItemStack wand, int index) {
        if (index < 0 || index > WandHelper.getSpells(wand).length) {
            return false;
        }
        if (WandHelper.getSpells(wand).length < 0) {
            WandHelper.setSpells(wand, new Spell[ItemWand.BASE_SPELL_SLOTS]);
        }
        if (wand.func_77978_p() != null) {
            wand.func_77978_p().func_74768_a(SELECTED_SPELL_KEY, index);
        }
        return true;
    }

    private static int getNextSpellIndex(ItemStack wand) {
        if (wand.func_77978_p() == null) {
            wand.func_77982_d(new NBTTagCompound());
        }
        int numberOfSpells = WandHelper.getSpells(wand).length;
        int spellIndex = wand.func_77978_p().func_74762_e(SELECTED_SPELL_KEY);
        spellIndex = spellIndex >= numberOfSpells - 1 ? 0 : ++spellIndex;
        return spellIndex;
    }

    private static int getPreviousSpellIndex(ItemStack wand) {
        if (wand.func_77978_p() == null) {
            wand.func_77982_d(new NBTTagCompound());
        }
        int numberOfSpells = WandHelper.getSpells(wand).length;
        int spellIndex = wand.func_77978_p().func_74762_e(SELECTED_SPELL_KEY);
        spellIndex = spellIndex <= 0 ? Math.max(0, numberOfSpells - 1) : --spellIndex;
        return spellIndex;
    }

    public static int[] getCooldowns(ItemStack wand) {
        int[] cooldowns = new int[]{};
        if (wand.func_77978_p() != null) {
            return wand.func_77978_p().func_74759_k(COOLDOWN_ARRAY_KEY);
        }
        return cooldowns;
    }

    public static void setCooldowns(ItemStack wand, int[] cooldowns) {
        if (wand.func_77978_p() == null) {
            wand.func_77982_d(new NBTTagCompound());
        }
        wand.func_77978_p().func_74783_a(COOLDOWN_ARRAY_KEY, cooldowns);
    }

    public static void decrementCooldowns(ItemStack wand) {
        int[] cooldowns = WandHelper.getCooldowns(wand);
        if (cooldowns.length == 0) {
            return;
        }
        for (int i = 0; i < cooldowns.length; ++i) {
            if (cooldowns[i] > 0) {
                int n = i;
                cooldowns[n] = cooldowns[n] - 1;
            }
            if (cooldowns[i] >= 0) continue;
            cooldowns[i] = 0;
        }
        WandHelper.setCooldowns(wand, cooldowns);
    }

    public static int getCurrentCooldown(ItemStack wand) {
        if (wand.func_77978_p() == null) {
            wand.func_77982_d(new NBTTagCompound());
        }
        int[] cooldowns = WandHelper.getCooldowns(wand);
        int selectedSpell = wand.func_77978_p().func_74762_e(SELECTED_SPELL_KEY);
        if (selectedSpell < 0 || cooldowns.length <= selectedSpell) {
            return 0;
        }
        return cooldowns[selectedSpell];
    }

    public static int getNextCooldown(ItemStack wand) {
        int[] cooldowns = WandHelper.getCooldowns(wand);
        int nextSpell = WandHelper.getNextSpellIndex(wand);
        if (nextSpell < 0 || cooldowns.length <= nextSpell) {
            return 0;
        }
        return cooldowns[nextSpell];
    }

    public static int getPreviousCooldown(ItemStack wand) {
        int[] cooldowns = WandHelper.getCooldowns(wand);
        int previousSpell = WandHelper.getPreviousSpellIndex(wand);
        if (previousSpell < 0 || cooldowns.length <= previousSpell) {
            return 0;
        }
        return cooldowns[previousSpell];
    }

    public static void setCurrentCooldown(ItemStack wand, int cooldown) {
        if (wand.func_77978_p() == null) {
            wand.func_77982_d(new NBTTagCompound());
        }
        int[] cooldowns = WandHelper.getCooldowns(wand);
        int selectedSpell = wand.func_77978_p().func_74762_e(SELECTED_SPELL_KEY);
        int spellCount = WandHelper.getSpells(wand).length;
        if (spellCount <= selectedSpell) {
            return;
        }
        if (cooldowns.length <= selectedSpell) {
            cooldowns = new int[spellCount];
        }
        if (cooldown <= 0) {
            cooldown = 1;
        }
        cooldowns[selectedSpell] = cooldown;
        WandHelper.setCooldowns(wand, cooldowns);
        int[] maxCooldowns = WandHelper.getMaxCooldowns(wand);
        if (maxCooldowns.length <= selectedSpell) {
            maxCooldowns = new int[spellCount];
        }
        maxCooldowns[selectedSpell] = cooldown;
        WandHelper.setMaxCooldowns(wand, maxCooldowns);
    }

    public static int[] getMaxCooldowns(ItemStack wand) {
        int[] cooldowns = new int[]{};
        if (wand.func_77978_p() != null) {
            return wand.func_77978_p().func_74759_k(MAX_COOLDOWN_ARRAY_KEY);
        }
        return cooldowns;
    }

    public static void setMaxCooldowns(ItemStack wand, int[] cooldowns) {
        if (wand.func_77978_p() == null) {
            wand.func_77982_d(new NBTTagCompound());
        }
        wand.func_77978_p().func_74783_a(MAX_COOLDOWN_ARRAY_KEY, cooldowns);
    }

    public static int getCurrentMaxCooldown(ItemStack wand) {
        int[] cooldowns = WandHelper.getMaxCooldowns(wand);
        if (wand.func_77978_p() == null) {
            return 0;
        }
        int selectedSpell = wand.func_77978_p().func_74762_e(SELECTED_SPELL_KEY);
        if (selectedSpell < 0 || cooldowns.length <= selectedSpell) {
            return 0;
        }
        return cooldowns[selectedSpell];
    }

    public static int getUpgradeLevel(ItemStack wand, Item upgrade) {
        String key = upgradeMap.get(upgrade);
        if (wand.func_77978_p() != null && wand.func_77978_p().func_74764_b(UPGRADES_KEY) && key != null) {
            return wand.func_77978_p().func_74775_l(UPGRADES_KEY).func_74762_e(key);
        }
        return 0;
    }

    public static int getTotalUpgrades(ItemStack wand) {
        int totalUpgrades = 0;
        for (Item item : upgradeMap.keySet()) {
            totalUpgrades += WandHelper.getUpgradeLevel(wand, item);
        }
        return totalUpgrades;
    }

    public static void applyUpgrade(ItemStack wand, Item upgrade) {
        if (wand.func_77978_p() == null) {
            wand.func_77982_d(new NBTTagCompound());
        }
        if (!wand.func_77978_p().func_74764_b(UPGRADES_KEY)) {
            NBTExtras.storeTagSafely(wand.func_77978_p(), UPGRADES_KEY, (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound upgrades = wand.func_77978_p().func_74775_l(UPGRADES_KEY);
        String key = upgradeMap.get(upgrade);
        if (key != null) {
            upgrades.func_74768_a(key, upgrades.func_74762_e(key) + 1);
        }
        NBTExtras.storeTagSafely(wand.func_77978_p(), UPGRADES_KEY, (NBTBase)upgrades);
    }

    public static boolean isWandUpgrade(Item upgrade) {
        return upgradeMap.containsKey(upgrade);
    }

    public static Set<Item> getSpecialUpgrades() {
        return Collections.unmodifiableSet(upgradeMap.keySet());
    }

    static String getIdentifier(Item upgrade) {
        if (!WandHelper.isWandUpgrade(upgrade)) {
            throw new IllegalArgumentException("Tried to get a wand upgrade key for an itemthat is not a registered special wand upgrade.");
        }
        return upgradeMap.get(upgrade);
    }

    public static void registerSpecialUpgrade(Item upgrade, String identifier) {
        if (upgradeMap.containsValue(identifier)) {
            throw new IllegalArgumentException("Duplicate wand upgrade identifier: " + identifier);
        }
        upgradeMap.put(upgrade, identifier);
    }

    public static void populateUpgradeMap() {
        upgradeMap.put(WizardryItems.condenser_upgrade, "condenser");
        upgradeMap.put(WizardryItems.storage_upgrade, "storage");
        upgradeMap.put(WizardryItems.siphon_upgrade, "siphon");
        upgradeMap.put(WizardryItems.range_upgrade, "range");
        upgradeMap.put(WizardryItems.duration_upgrade, "duration");
        upgradeMap.put(WizardryItems.cooldown_upgrade, COOLDOWN_ARRAY_KEY);
        upgradeMap.put(WizardryItems.blast_upgrade, "blast");
        upgradeMap.put(WizardryItems.attunement_upgrade, "attunement");
        upgradeMap.put(WizardryItems.melee_upgrade, "melee");
    }

    public static void setProgression(ItemStack wand, int progression) {
        if (wand.func_77978_p() == null) {
            wand.func_77982_d(new NBTTagCompound());
        }
        wand.func_77978_p().func_74768_a(PROGRESSION_KEY, progression);
    }

    public static int getProgression(ItemStack wand) {
        if (wand.func_77978_p() == null) {
            return 0;
        }
        return wand.func_77978_p().func_74762_e(PROGRESSION_KEY);
    }

    public static void addProgression(ItemStack wand, int progression) {
        WandHelper.setProgression(wand, WandHelper.getProgression(wand) + progression);
    }

    public static boolean rechargeManaOnApplyButtonPressed(Slot centre, Slot crystals) {
        boolean changed = false;
        if (!(centre.func_75211_c().func_77973_b() instanceof IWorkbenchItem) || !(centre.func_75211_c().func_77973_b() instanceof IManaStoringItem)) {
            return false;
        }
        IManaStoringItem iManaStoringItem = (IManaStoringItem)centre.func_75211_c().func_77973_b();
        if (crystals.func_75211_c() != ItemStack.field_190927_a && !iManaStoringItem.isManaFull(centre.func_75211_c())) {
            int manaPerItem;
            int chargeDepleted = iManaStoringItem.getManaCapacity(centre.func_75211_c()) - iManaStoringItem.getMana(centre.func_75211_c());
            int n = crystals.func_75211_c().func_77973_b() instanceof IManaStoringItem ? ((IManaStoringItem)crystals.func_75211_c().func_77973_b()).getMana(crystals.func_75211_c()) : (manaPerItem = crystals.func_75211_c().func_77973_b() instanceof ItemCrystal ? Constants.MANA_PER_CRYSTAL : Constants.MANA_PER_SHARD);
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.crystal_shard) {
                manaPerItem = Constants.MANA_PER_SHARD;
            }
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.grand_crystal) {
                manaPerItem = Constants.GRAND_CRYSTAL_MANA;
            }
            if (crystals.func_75211_c().func_190916_E() * manaPerItem < chargeDepleted) {
                iManaStoringItem.rechargeMana(centre.func_75211_c(), crystals.func_75211_c().func_190916_E() * manaPerItem);
                crystals.func_75209_a(crystals.func_75211_c().func_190916_E());
            } else {
                iManaStoringItem.setMana(centre.func_75211_c(), iManaStoringItem.getManaCapacity(centre.func_75211_c()));
                crystals.func_75209_a((int)Math.ceil((double)chargeDepleted / (double)manaPerItem));
            }
            changed = true;
        }
        return changed;
    }
}

