/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.EnderCore;
import javax.annotation.Nonnull;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextFormatting;

public class EnderStringUtils {
    @Nonnull
    public static String formatString(String prefix, String suffix, long amnt, boolean useDecimals, boolean formatK) {
        if (formatK && Long.toString(amnt).length() < 7 && Long.toString(amnt).length() > 3) {
            return EnderStringUtils.formatSmallerNumber(prefix, suffix, amnt, useDecimals);
        }
        switch (Long.toString(amnt).length()) {
            case 7: {
                return prefix + Long.toString(amnt).substring(0, 1) + (useDecimals ? "." + Long.toString(amnt).substring(1, 3) : "") + "M" + suffix;
            }
            case 8: {
                return prefix + Long.toString(amnt).substring(0, 2) + (useDecimals ? "." + Long.toString(amnt).substring(2, 4) : "") + "M" + suffix;
            }
            case 9: {
                return prefix + Long.toString(amnt).substring(0, 3) + (useDecimals ? "." + Long.toString(amnt).substring(3, 5) : "") + "M" + suffix;
            }
            case 10: {
                return prefix + Long.toString(amnt).substring(0, 1) + (useDecimals ? "." + Long.toString(amnt).substring(1, 3) : "") + "B" + suffix;
            }
            case 11: {
                return prefix + Long.toString(amnt).substring(0, 2) + (useDecimals ? "." + Long.toString(amnt).substring(2, 4) : "") + "B" + suffix;
            }
            case 12: {
                return prefix + Long.toString(amnt).substring(0, 3) + (useDecimals ? "." + Long.toString(amnt).substring(3, 5) : "") + "B" + suffix;
            }
            case 13: {
                return prefix + Long.toString(amnt).substring(0, 1) + (useDecimals ? "." + Long.toString(amnt).substring(1, 5) : "") + "T" + suffix;
            }
        }
        return prefix + "" + amnt + suffix;
    }

    @Nonnull
    public static String formatString(String prefix, String suffix, long amnt, boolean useDecimals) {
        return EnderStringUtils.formatString(prefix, suffix, amnt, useDecimals, false);
    }

    @Nonnull
    private static String formatSmallerNumber(String prefix, String suffix, long amnt, boolean useDecimals) {
        switch (Long.toString(amnt).length()) {
            case 4: {
                return prefix + Long.toString(amnt).substring(0, 1) + (useDecimals ? "." + Long.toString(amnt).substring(1, 3) : "") + "K" + suffix;
            }
            case 5: {
                return prefix + Long.toString(amnt).substring(0, 2) + (useDecimals ? "." + Long.toString(amnt).substring(2, 4) : "") + "K" + suffix;
            }
            case 6: {
                return prefix + Long.toString(amnt).substring(0, 3) + (useDecimals ? "." + Long.toString(amnt).substring(3, 5) : "") + "K" + suffix;
            }
        }
        return "";
    }

    @Nonnull
    public static TextFormatting getColorFor(double num, double max) {
        if (num / max <= 0.1) {
            return TextFormatting.RED;
        }
        if (num / max <= 0.25) {
            return TextFormatting.GOLD;
        }
        return TextFormatting.GREEN;
    }

    @Nonnull
    public static String getEffectNameWithLevel(@Nonnull PotionEffect effect) {
        String name = EnderCore.lang.localize(effect.func_76453_d(), false);
        if (effect.func_76458_c() > 0) {
            name = name + " " + EnderCore.lang.localize("enchantment.level." + (effect.func_76458_c() + 1), false);
        }
        return name;
    }
}

