/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util.stackable;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.IThing;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemStack;

class BlockThing
implements IThing {
    @Nonnull
    private final Block thing;
    @Nullable
    private final Item blockItem;

    public BlockThing(@Nonnull Block block) {
        this.thing = block;
        this.blockItem = BlockThing.findBlockItem(block);
    }

    @Nullable
    public static Item findBlockItem(@Nonnull Block block) {
        Item item = Item.func_150898_a((Block)block);
        if (item != Items.field_190931_a) {
            return item;
        }
        for (Item candidate : Item.field_150901_e) {
            if (candidate instanceof ItemBlockSpecial && ((ItemBlockSpecial)candidate).getBlock() == block) {
                return candidate;
            }
            if (!(candidate instanceof ItemBlock) || ((ItemBlock)candidate).func_179223_d() != block) continue;
            return candidate;
        }
        return null;
    }

    @Override
    @Nonnull
    public NNList<IThing> bake() {
        return new NNList<IThing>(this);
    }

    @Override
    public boolean is(@Nullable Item item) {
        return this.blockItem == item;
    }

    @Override
    public boolean is(@Nullable ItemStack itemStack) {
        return itemStack != null && !itemStack.func_190926_b() && this.is(itemStack.func_77973_b());
    }

    @Override
    public boolean is(@Nullable Block block) {
        return this.thing == block;
    }

    @Override
    @Nonnull
    public NNList<Item> getItems() {
        return this.blockItem != null ? new NNList<Item>(this.blockItem) : NNList.emptyList();
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getItemStacks() {
        return this.blockItem != null ? new NNList<ItemStack>(new ItemStack(this.blockItem)) : NNList.emptyList();
    }

    @Override
    @Nonnull
    public NNList<Block> getBlocks() {
        return new NNList<Block>(this.thing);
    }

    public String toString() {
        return String.format("BlockThing [thing=%s, item= %s]", this.thing, this.blockItem);
    }
}

