/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.diagnostics;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.profiler.Profiler;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Prof {
    private static ThreadLocal<Counter> counter = ThreadLocal.withInitial(() -> new Counter());

    public static void start(@Nonnull IBlockAccess world, @Nonnull String section) {
        Prof.start(Prof.getProfiler(world), section);
    }

    public static void start(@Nonnull IBlockAccess world, @Nonnull String section, @Nullable Object param) {
        Prof.start(Prof.getProfiler(world), section, param);
    }

    public static void next(@Nonnull IBlockAccess world, @Nonnull String section) {
        Prof.next(Prof.getProfiler(world), section);
    }

    public static void next(@Nonnull IBlockAccess world, @Nonnull String section, @Nullable Object param) {
        Prof.next(Prof.getProfiler(world), section, param);
    }

    public static void stop(@Nonnull IBlockAccess world) {
        Prof.stop(Prof.getProfiler(world));
    }

    public static void start(@Nullable Profiler profiler, @Nonnull String section) {
        if (profiler != null) {
            profiler.func_76320_a(section);
        }
        ++Prof.counter.get().count;
    }

    public static void start(@Nullable Profiler profiler, @Nonnull String section, @Nullable Object param) {
        if (profiler != null) {
            profiler.func_76320_a(Prof.makeSection(section, param));
        }
        ++Prof.counter.get().count;
    }

    public static void next(@Nullable Profiler profiler, @Nonnull String section) {
        if (profiler != null) {
            profiler.func_76318_c(section);
        }
    }

    public static void next(@Nullable Profiler profiler, @Nonnull String section, @Nullable Object param) {
        if (profiler != null) {
            profiler.func_76318_c(Prof.makeSection(section, param));
        }
    }

    public static void stop(@Nullable Profiler profiler) {
        if (--Prof.counter.get().count >= 0) {
            if (profiler != null) {
                profiler.func_76319_b();
            }
        } else {
            new RuntimeException("Profiler underflow!").printStackTrace();
        }
    }

    public static void stop(@Nullable Profiler profiler, int count) {
        for (int i = 0; i < count; ++i) {
            Prof.stop(profiler);
        }
    }

    @Nonnull
    private static String makeSection(@Nonnull String section, @Nullable Object param) {
        if (param != null) {
            return section + param.getClass().getName().replace(".", "_").replaceAll("[^a-zA-Z_]", "").replace("crazypants_enderio_machines_machine_", "");
        }
        return section;
    }

    private static Profiler getProfiler(@Nonnull IBlockAccess world) {
        if (world instanceof World) {
            Profiler profiler = ((World)world).field_72984_F;
            return profiler.field_76327_a ? profiler : null;
        }
        return null;
    }

    private static class Counter {
        int count = 0;

        private Counter() {
        }
    }
}

