/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.baubles;

import baubles.api.BaublesApi;
import crazypants.enderio.base.config.config.IntegrationConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;

public class BaublesUtil {
    private static final BaublesUtil instance = new BaublesUtil();

    private BaublesUtil() {
    }

    public static BaublesUtil instance() {
        return instance;
    }

    public boolean hasBaubles() {
        return (Boolean)IntegrationConfig.enableBaubles.get() != false && Loader.isModLoaded((String)"baubles");
    }

    public IInventory getBaubles(EntityPlayer player) {
        return this.hasBaubles() ? this.getBaublesInvUnsafe(player) : null;
    }

    private IInventory getBaublesInvUnsafe(EntityPlayer player) {
        return BaublesApi.getBaubles((EntityPlayer)player);
    }

    public static enum WhoAmI {
        SPCLIENT,
        MPCLIENT,
        SPSERVER,
        MPSERVER,
        OTHER;


        public static WhoAmI whoAmI(World world) {
            Side side = FMLCommonHandler.instance().getSide();
            if (side == Side.CLIENT) {
                if (Minecraft.func_71410_x().func_71387_A()) {
                    if (world.field_72995_K) {
                        return SPCLIENT;
                    }
                    return SPSERVER;
                }
                return MPCLIENT;
            }
            if (side == Side.SERVER) {
                if (FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S()) {
                    return MPSERVER;
                }
                if (Minecraft.func_71410_x().func_71387_A()) {
                    return SPSERVER;
                }
            }
            return OTHER;
        }
    }
}

