/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.jei;

import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class ItemHelper {
    @Nonnull
    private static final NNList<ItemStack> list = new NNList();

    private ItemHelper() {
    }

    @Nonnull
    public static NNList<ItemStack> getValidItems() {
        if (list.isEmpty()) {
            NNList sublist = new NNList();
            Walker callback = new Walker();
            for (Item item : Item.field_150901_e) {
                if (!callback.set(item)) continue;
                item.func_150895_a(CreativeTabs.field_78027_g, (NonNullList)sublist);
                sublist.apply((NNList.Callback)callback);
                sublist.clear();
            }
        }
        return list;
    }

    protected static final class Walker
    implements NNList.Callback<ItemStack> {
        private Item item;

        protected boolean set(Item item) {
            this.item = item;
            if (item instanceof ItemBlock) {
                Block block = ((ItemBlock)item).func_179223_d();
                if (NullHelper.untrust((Object)block) == null) {
                    Log.error("ItemBlock " + item + " returned null from getBlock(). This is a major bug in the mod '" + PaintUtil.block2Modname(item) + "'.");
                    return false;
                }
                if (NullHelper.untrust((Object)Block.field_149771_c.func_177774_c((Object)block)) == null) {
                    Log.error("ItemBlock " + item + " returned an unregistered block from getBlock(). This is a major bug in the mod '" + PaintUtil.block2Modname(item) + "'.");
                    return false;
                }
                if (block instanceof IFluidBlock) {
                    Fluid fluid = ((IFluidBlock)block).getFluid();
                    if (fluid == null) {
                        Log.error("Block " + block + " returned null from getFluid(). This is a major bug in the mod '" + PaintUtil.block2Modname(block) + "'.");
                        return false;
                    }
                    Block fblock = fluid.getBlock();
                    if (fblock != null && NullHelper.untrust((Object)Block.field_149771_c.func_177774_c((Object)fblock)) == null) {
                        Log.error("Fluid " + fluid + " (" + fluid.getName() + ", " + fluid.getClass() + ") from block " + block + " returned an unregistered block from getBlock(). This is a major bug in the mod '" + PaintUtil.block2Modname(block) + "'.");
                        return false;
                    }
                }
            }
            return true;
        }

        protected Walker() {
        }

        public void apply(@Nonnull ItemStack stack) {
            Block block;
            if (Prep.isInvalid(stack)) {
                Log.error("The item " + this.item + " (" + this.item.func_77658_a() + ") produces empty itemstacks in getSubItems(). This is a major bug in the mod '" + PaintUtil.block2Modname(this.item) + "'.");
                return;
            }
            if (stack.func_77973_b() == Items.field_190931_a) {
                Log.error("The item " + this.item + " (" + this.item.func_77658_a() + ") produces itemstacks without item in getSubItems(). This is a major bug in the mod '" + PaintUtil.block2Modname(this.item) + "'.");
                return;
            }
            FluidStack fluidStack = FluidUtil.getFluidTypeFromItem((ItemStack)stack);
            if (fluidStack != null && fluidStack.getFluid() != null && (block = fluidStack.getFluid().getBlock()) != null && NullHelper.untrust((Object)Block.field_149771_c.func_177774_c((Object)block)) == null) {
                Log.error("Fluid " + fluidStack.getFluid() + " (" + fluidStack.getFluid().getName() + ", " + fluidStack.getFluid().getClass() + ") from item " + stack + " returned an unregistered block from getBlock(). This is a major bug in the mod that fluid belongs to.");
                return;
            }
            list.add((Object)stack);
        }
    }
}

