/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.farm;

import com.enderio.core.client.gui.GhostSlotHandler;
import com.enderio.core.client.gui.widget.GhostBackgroundItemSlot;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.farming.FarmersRegistry;
import crazypants.enderio.base.farming.fertilizer.Fertilizer;
import crazypants.enderio.base.machine.gui.AbstractMachineContainer;
import crazypants.enderio.machines.machine.farm.TileFarmStation;
import java.awt.Point;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class FarmStationContainer
extends AbstractMachineContainer<TileFarmStation> {
    private static final int ROW_TOOLS = 19;
    private static final int ROW_IO = 44;
    private static final int COL_TOOLS = 44;
    private static final int COL_INPUT = 53;
    private static final int COL_FERTILIZER = 116;
    private static final int COL_OUTPUT = 107;
    private static final int SLOT_SIZE = 18;
    private static final int ONE = 0;
    private static final int TWO = 18;
    private static final int THREE = 36;
    private static final SlotPoint[] points = new SlotPoint[]{new SlotPoint(44, 19, FarmersRegistry.slotItemsHoeTools), new SlotPoint(62, 19, FarmersRegistry.slotItemsAxeTools), new SlotPoint(80, 19, FarmersRegistry.slotItemsExtraTools), new SlotPoint(116, 19, Fertilizer.getStacks()), new SlotPoint(134, 19, Fertilizer.getStacks()), new SlotPoint(53, 44, FarmersRegistry.slotItemsSeeds), new SlotPoint(71, 44, FarmersRegistry.slotItemsSeeds), new SlotPoint(53, 62, FarmersRegistry.slotItemsSeeds), new SlotPoint(71, 62, FarmersRegistry.slotItemsSeeds), new SlotPoint(107, 44, FarmersRegistry.slotItemsProduce), new SlotPoint(125, 44, FarmersRegistry.slotItemsProduce), new SlotPoint(143, 44, FarmersRegistry.slotItemsProduce), new SlotPoint(107, 62, FarmersRegistry.slotItemsProduce), new SlotPoint(125, 62, FarmersRegistry.slotItemsProduce), new SlotPoint(143, 62, FarmersRegistry.slotItemsProduce)};

    public FarmStationContainer(@Nonnull InventoryPlayer inventory, @Nonnull TileFarmStation te) {
        super(inventory, te);
    }

    @Override
    protected void addMachineSlots(@Nonnull InventoryPlayer playerInv) {
        int i = 0;
        for (SlotPoint p : points) {
            final int slot = i++;
            p.s = new Slot(this.getInv(), slot, p.x, p.y){

                public boolean func_75214_a(@Nonnull ItemStack itemStack) {
                    return ((TileFarmStation)FarmStationContainer.this.getTe()).isItemValidForSlot(slot, itemStack);
                }

                public int func_75219_a() {
                    return ((TileFarmStation)FarmStationContainer.this.getTe()).getInventoryStackLimit(slot);
                }
            };
            this.func_75146_a(p.s);
        }
    }

    public void createGhostSlots(GhostSlotHandler slots) {
        for (SlotPoint p : points) {
            Slot slot = p.s;
            if (slot == null) continue;
            slots.add((GhostSlot)new GhostBackgroundItemSlot(p.getGhosts(), slot));
        }
    }

    @Override
    @Nonnull
    public Point getPlayerInventoryOffset() {
        return new Point(8, 87);
    }

    @Override
    @Nonnull
    public Point getUpgradeOffset() {
        return new Point(12, 63);
    }

    private static class SlotPoint {
        int x;
        int y;
        private Things ghosts;
        private NNList<ItemStack> stacks;
        Slot s = null;

        SlotPoint(int x, int y, @Nonnull Things ghosts) {
            this.x = x;
            this.y = y;
            this.ghosts = ghosts;
        }

        SlotPoint(int x, int y, @Nonnull NNList<ItemStack> stacks) {
            this.x = x;
            this.y = y;
            this.stacks = stacks;
        }

        @Nonnull
        NNList<ItemStack> getGhosts() {
            return this.ghosts != null ? this.ghosts.getItemStacks() : (this.stacks != null ? this.stacks : NNList.emptyList());
        }
    }
}

