/*
 * Decompiled with CFR 0.152.
 */
package extracells.container.fluid;

import appeng.api.util.AEPartLocation;
import extracells.api.IFluidInterface;
import extracells.container.IContainerListener;
import extracells.container.slot.SlotRespective;
import extracells.gui.fluid.GuiFluidInterface;
import extracells.network.packet.part.PacketFluidInterface;
import extracells.part.fluid.PartFluidInterface;
import extracells.tileentity.TileEntityFluidInterface;
import extracells.util.NetworkUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerFluidInterface
extends Container
implements IContainerListener {
    public IFluidInterface fluidInterface;
    @SideOnly(value=Side.CLIENT)
    public GuiFluidInterface gui;
    EntityPlayer player;

    public ContainerFluidInterface(EntityPlayer player, IFluidInterface fluidInterface) {
        this.player = player;
        this.fluidInterface = fluidInterface;
        for (int j = 0; j < 9; ++j) {
            this.func_75146_a(new SlotRespective(fluidInterface.getPatternInventory(), j, 8 + j * 18, 115));
        }
        this.bindPlayerInventory((IInventory)player.field_71071_by);
        if (fluidInterface instanceof TileEntityFluidInterface) {
            ((TileEntityFluidInterface)fluidInterface).registerListener(this);
        } else if (fluidInterface instanceof PartFluidInterface) {
            ((PartFluidInterface)fluidInterface).registerListener(this);
        }
        if (fluidInterface instanceof TileEntityFluidInterface) {
            ((TileEntityFluidInterface)fluidInterface).doNextUpdate = true;
        } else if (fluidInterface instanceof PartFluidInterface) {
            ((PartFluidInterface)fluidInterface).doNextUpdate = true;
        }
    }

    protected void bindPlayerInventory(IInventory inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot(inventoryPlayer, j + i * 9 + 9, 8 + j * 18, i * 18 + 149));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot(inventoryPlayer, i, 8 + i * 18, 207));
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    private String getFluidName(AEPartLocation side) {
        Fluid fluid = this.fluidInterface.getFilter(side);
        if (fluid == null) {
            return "";
        }
        return fluid.getName();
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.fluidInterface instanceof TileEntityFluidInterface) {
            ((TileEntityFluidInterface)this.fluidInterface).removeListener(this);
        } else if (this.fluidInterface instanceof PartFluidInterface) {
            ((PartFluidInterface)this.fluidInterface).removeListener(this);
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotnumber) {
        ItemStack transferStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotnumber);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack = slot.func_75211_c();
            transferStack = itemStack.func_77946_l();
            if (slotnumber < 9 ? !this.func_75135_a(itemStack, 9, this.field_75151_b.size(), false) : (slotnumber < 36 ? !this.func_75135_a(itemStack, 0, 9, false) && !this.func_75135_a(itemStack, 36, this.field_75151_b.size(), false) : !this.func_75135_a(itemStack, 0, 9, false) && !this.func_75135_a(itemStack, 9, 36, false))) {
                return ItemStack.field_190927_a;
            }
            if (itemStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return transferStack;
    }

    @Override
    public void updateContainer() {
        FluidStack[] fluidStacks = new FluidStack[6];
        String[] fluidNames = new String[6];
        for (int i = 0; i < 6; ++i) {
            AEPartLocation location = AEPartLocation.fromOrdinal((int)i);
            fluidStacks[i] = this.fluidInterface.getFluidTank(location).getFluid();
            fluidNames[i] = this.getFluidName(location);
        }
        NetworkUtil.sendToPlayer(new PacketFluidInterface(fluidStacks, fluidNames), this.player);
    }
}

