/*
 * Decompiled with CFR 0.152.
 */
package extracells.gui;

import extracells.gui.ISlotRenderer;
import extracells.gui.IToolTipProvider;
import extracells.gui.widget.WidgetManager;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;

public class GuiBase<C extends Container>
extends GuiContainer {
    protected final C container;
    public final ResourceLocation textureFile;
    protected final WidgetManager widgetManager = this.createWidgetManager();

    public GuiBase(ResourceLocation texture, C container) {
        super(container);
        this.textureFile = texture;
        this.container = container;
    }

    protected WidgetManager createWidgetManager() {
        return new WidgetManager(this);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.textureFile);
        this.drawBackground();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.widgetManager.drawWidgets(mouseX, mouseY);
        GlStateManager.func_179121_F();
        if (this.hasSlotRenders()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
            for (Slot slot : ((Container)this.container).field_75151_b) {
                ISlotRenderer slotRenderer = this.getSlotRenderer(slot);
                if (slotRenderer == null) continue;
                slotRenderer.renderBackground(slot, this, mouseX, mouseY);
            }
            GlStateManager.func_179121_F();
        }
        this.bindTexture(this.textureFile);
    }

    protected void drawBackground() {
        this.func_73729_b(this.field_147003_i + this.getOffsetX(), this.field_147009_r + this.getOffsetY(), this.getTextureOffsetX(), this.getTextureOffsetY(), this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.hasSlotRenders()) {
            GlStateManager.func_179094_E();
            for (Slot slot : ((Container)this.container).field_75151_b) {
                ISlotRenderer slotRenderer = this.getSlotRenderer(slot);
                if (slotRenderer == null) continue;
                slotRenderer.renderForeground(slot, this, mouseX, mouseY);
            }
            GlStateManager.func_179121_F();
        }
    }

    public void func_73733_a(int left, int top, int right, int bottom, int startColor, int endColor) {
        super.func_73733_a(left, top, right, bottom, startColor, endColor);
    }

    protected int getOffsetX() {
        return 0;
    }

    protected int getOffsetY() {
        return 0;
    }

    protected int getTextureOffsetX() {
        return 0;
    }

    protected int getTextureOffsetY() {
        return 0;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GuiBase.drawToolTips(this, this.field_146292_n, mouseX, mouseY);
        GuiBase.drawToolTips(this, this.widgetManager.getWidgets(), mouseX, mouseY);
        this.func_191948_b(mouseX, mouseY);
    }

    public static void drawToolTips(GuiBase gui, Collection<?> objects, int mouseX, int mouseY) {
        for (Object obj : objects) {
            boolean mouseOver;
            IToolTipProvider provider;
            List<String> tooltip;
            if (!(obj instanceof IToolTipProvider) || (tooltip = (provider = (IToolTipProvider)obj).getToolTip(mouseX - gui.getGuiLeft(), mouseY - gui.getGuiTop())) == null || !(mouseOver = provider.isMouseOver(mouseX - gui.getGuiLeft(), mouseY - gui.getGuiTop())) || tooltip.isEmpty()) continue;
            Minecraft mc = Minecraft.func_71410_x();
            GlStateManager.func_179094_E();
            ScaledResolution scaledresolution = new ScaledResolution(mc);
            GuiUtils.drawHoveringText(tooltip, (int)mouseX, (int)mouseY, (int)scaledresolution.func_78326_a(), (int)scaledresolution.func_78328_b(), (int)-1, (FontRenderer)mc.field_71466_p);
            GlStateManager.func_179121_F();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.widgetManager.handleMouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void bindTexture(ResourceLocation texturePath) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(texturePath);
    }

    public int getSizeX() {
        return this.field_146999_f;
    }

    public int getSizeY() {
        return this.field_147000_g;
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public void setZLevel(float zLevel) {
        this.field_73735_i = zLevel;
    }

    protected boolean hasSlotRenders() {
        return false;
    }

    @Nullable
    protected ISlotRenderer getSlotRenderer(Slot slot) {
        return null;
    }
}

