/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Color;
import java.util.Locale;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.config.ColorConfig;

public class OverlayConfig {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().registerTypeAdapter(ColorConfig.class, (Object)new ColorConfig.Serializer()).create();
    public static int posX;
    public static int posY;
    public static int alpha;
    public static int bgcolor;
    public static int gradient1;
    public static int gradient2;
    public static int fontcolor;
    public static float scale;

    public static void updateColors() {
        int alphaC = ConfigHandler.instance().getConfig("general", "waila.cfg.alpha", 80);
        alpha = alphaC == 100 ? 255 : (alphaC == 0 ? 0x1000000 : (int)((float)alphaC / 100.0f * 256.0f) << 24);
        bgcolor = alpha + ConfigHandler.instance().getConfig("general", "waila.cfg.bgcolor", 0x100010);
        gradient1 = alpha + ConfigHandler.instance().getConfig("general", "waila.cfg.gradient1", 0x5000FF);
        gradient2 = alpha + ConfigHandler.instance().getConfig("general", "waila.cfg.gradient2", 2621567);
        fontcolor = ConfigHandler.instance().getConfig("general", "waila.cfg.fontcolor", 0xA0A0A0);
    }

    public static String toHex(Color color) {
        return "#" + Integer.toHexString(color.getRGB()).substring(2).toUpperCase(Locale.ENGLISH);
    }

    public static Color fromHex(String hex) {
        try {
            return Color.decode(hex);
        }
        catch (NumberFormatException e) {
            System.out.println(hex + " - no");
            return Color.BLACK;
        }
    }
}

