/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.button.GuiButtonDisableableImage;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.ContainerResistiveHeater;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityResistiveHeater;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiResistiveHeater
extends GuiMekanismTile<TileEntityResistiveHeater> {
    private GuiTextField energyUsageField;
    private GuiButton checkboxButton;

    public GuiResistiveHeater(InventoryPlayer inventory, TileEntityResistiveHeater tile) {
        super(tile, new ContainerResistiveHeater(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 164, 15));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 14, 34).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            String multiplier = MekanismUtils.getEnergyDisplay(((TileEntityResistiveHeater)this.tileEntity).energyUsage);
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityResistiveHeater)this.tileEntity).getMaxEnergy() - ((TileEntityResistiveHeater)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiHeatInfo(() -> {
            UnitDisplayUtils.TemperatureUnit unit = UnitDisplayUtils.TemperatureUnit.values()[MekanismConfig.current().general.tempUnit.val().ordinal()];
            String environment = UnitDisplayUtils.getDisplayShort(((TileEntityResistiveHeater)this.tileEntity).lastEnvironmentLoss * unit.intervalSize, false, unit);
            return Collections.singletonList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
        }, (IGuiWrapper)this, resource));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        String prevEnergyUsage = this.energyUsageField != null ? this.energyUsageField.func_146179_b() : "";
        this.energyUsageField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 49, this.field_147009_r + 52, 66, 11);
        this.energyUsageField.func_146203_f(7);
        this.energyUsageField.func_146185_a(false);
        this.energyUsageField.func_146180_a(prevEnergyUsage);
        this.checkboxButton = new GuiButtonDisableableImage(1, this.field_147003_i + 116, this.field_147009_r + 51, 11, 11, this.field_146999_f, 11, -11, this.getGuiLocation());
        this.field_146292_n.add(this.checkboxButton);
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.checkboxButton.field_146127_k) {
            this.setEnergyUsage();
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityResistiveHeater)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityResistiveHeater)this.tileEntity).func_70005_c_()) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 94 + 2, 0x404040);
        this.renderScaledText(LangUtils.localize("gui.temp") + ": " + MekanismUtils.getTemperatureDisplay(((TileEntityResistiveHeater)this.tileEntity).temperature, UnitDisplayUtils.TemperatureUnit.AMBIENT), 50, 25, 52480, 76);
        this.renderScaledText(LangUtils.localize("gui.usage") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityResistiveHeater)this.tileEntity).energyUsage) + "/t", 50, 41, 52480, 76);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.energyUsageField.func_146194_f();
        MekanismRenderer.resetColor();
    }

    private void setEnergyUsage() {
        if (!this.energyUsageField.func_146179_b().isEmpty()) {
            int toUse = Integer.parseInt(this.energyUsageField.func_146179_b());
            TileNetworkList data = TileNetworkList.withContents(toUse);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
            this.energyUsageField.func_146180_a("");
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.energyUsageField.func_146178_a();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.energyUsageField.func_146192_a(mouseX, mouseY, button);
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiResistiveHeater.png");
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.energyUsageField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (this.energyUsageField.func_146206_l() && i == 28) {
            this.setEnergyUsage();
            return;
        }
        if (Character.isDigit(c) || GuiResistiveHeater.isTextboxKey(c, i)) {
            this.energyUsageField.func_146201_a(c, i);
        }
    }
}

