/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.client.gui;

import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiCustomSlot;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.client.render.BlockPosHighlighter;
import appeng.container.interfaces.IJEIGhostIngredients;
import appeng.core.localization.GuiText;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.helpers.InventoryAction;
import appeng.util.BlockPosUtils;
import com.google.common.collect.HashMultimap;
import com.mekeng.github.MekEng;
import com.mekeng.github.client.slots.SlotGasTank;
import com.mekeng.github.common.container.ContainerGasInterfaceConfigurationTerminal;
import com.mekeng.github.common.me.client.ClientDCInternalGasInv;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.part.PartGasInterfaceConfigurationTerminal;
import com.mekeng.github.network.packet.CGenericPacket;
import com.mekeng.github.network.packet.sync.IActionHolder;
import com.mekeng.github.network.packet.sync.Paras;
import com.mekeng.github.util.Utils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiGasInterfaceConfigurationTerminal
extends AEBaseGui
implements IJEIGhostIngredients,
IActionHolder {
    private static final int LINES_ON_PAGE = 6;
    private final int offsetX = 21;
    private final HashMap<Long, ClientDCInternalGasInv> byId = new HashMap();
    private final HashMultimap<String, ClientDCInternalGasInv> byName = HashMultimap.create();
    private final HashMap<ClientDCInternalGasInv, BlockPos> blockPosHashMap = new HashMap();
    private final HashMap<GuiButton, ClientDCInternalGasInv> guiButtonHashMap = new HashMap();
    private final Map<SlotGasTank, ClientDCInternalGasInv> guiGasTankClientDCInternalGasInvMap = new Object2ObjectOpenHashMap();
    private final Map<ClientDCInternalGasInv, Integer> numUpgradesMap = new HashMap<ClientDCInternalGasInv, Integer>();
    private final ArrayList<String> names = new ArrayList();
    private final ArrayList<Object> lines = new ArrayList();
    private final Set<Object> matchedStacks = new HashSet<Object>();
    private final Set<ClientDCInternalGasInv> matchedInterfaces = new HashSet<ClientDCInternalGasInv>();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private boolean refreshList = false;
    private MEGuiTextField searchFieldInputs;
    private final PartGasInterfaceConfigurationTerminal partInterfaceTerminal;
    private final HashMap<ClientDCInternalGasInv, Integer> dimHashMap = new HashMap();
    public Map<IGhostIngredientHandler.Target<?>, Object> mapTargetSlot = new HashMap();
    private final Map<String, Consumer<Paras>> holder = this.createHolder();

    public GuiGasInterfaceConfigurationTerminal(InventoryPlayer inventoryPlayer, PartGasInterfaceConfigurationTerminal te) {
        super((Container)new ContainerGasInterfaceConfigurationTerminal(inventoryPlayer, te));
        this.holder.put("update", o -> this.postUpdate((NBTTagCompound)o.get(0)));
        this.partInterfaceTerminal = te;
        GuiScrollbar scrollbar = new GuiScrollbar();
        this.setScrollBar(scrollbar);
        this.field_146999_f = 208;
        this.field_147000_g = 235;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.getScrollBar().setLeft(189);
        this.getScrollBar().setHeight(106);
        this.getScrollBar().setTop(31);
        this.searchFieldInputs = new MEGuiTextField(this.field_146289_q, this.field_147003_i + Math.max(32, this.offsetX), this.field_147009_r + 17, 65, 12);
        this.searchFieldInputs.func_146185_a(false);
        this.searchFieldInputs.func_146203_f(25);
        this.searchFieldInputs.func_146193_g(0xFFFFFF);
        this.searchFieldInputs.func_146189_e(true);
        this.searchFieldInputs.func_146195_b(false);
        this.searchFieldInputs.func_146180_a(this.partInterfaceTerminal.in);
    }

    public void func_146281_b() {
        this.partInterfaceTerminal.saveSearchStrings(this.searchFieldInputs.func_146179_b().toLowerCase());
        super.func_146281_b();
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146292_n.clear();
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(I18n.func_135052_a((String)"gui.mekeng.gas_interface_terminal", (Object[])new Object[0])), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), this.offsetX + 2, this.field_147000_g - 96 + 3, 0x404040);
        int currentScroll = this.getScrollBar().getCurrentScroll();
        this.guiSlots.removeIf(slot -> slot instanceof SlotGasTank);
        int offset = 30;
        int linesDraw = 0;
        for (int x = 0; x < 6 && linesDraw < 6 && currentScroll + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(currentScroll + x);
            if (lineObj instanceof ClientDCInternalGasInv) {
                ClientDCInternalGasInv inv = (ClientDCInternalGasInv)lineObj;
                GuiImgButton guiButton = new GuiImgButton(this.field_147003_i + 4, this.field_147009_r + offset, (Enum)Settings.ACTIONS, (Enum)ActionItems.HIGHLIGHT_INTERFACE);
                this.guiButtonHashMap.put((GuiButton)guiButton, inv);
                this.field_146292_n.add(guiButton);
                int extraLines = this.numUpgradesMap.get(inv);
                for (int row = 0; row < 1 + extraLines && linesDraw < 6; ++row) {
                    for (int z = 0; z < 9; ++z) {
                        SlotGasTank tankSlot = !this.matchedInterfaces.contains(inv) && !this.matchedStacks.contains(inv.getInventory().getGasStack(z + row * 5)) ? new SlotGasTank(inv.getInventory(), z + row * 5, z + row * 5, z * 18 + 22, offset, 16, 16, true) : new SlotGasTank(inv.getInventory(), z + row * 5, z + row * 5, z * 18 + 22, offset, 16, 16);
                        this.guiSlots.add(tankSlot);
                        this.guiGasTankClientDCInternalGasInvMap.put(tankSlot, inv);
                    }
                    ++linesDraw;
                    offset += 18;
                }
                continue;
            }
            if (!(lineObj instanceof String)) continue;
            String name = (String)lineObj;
            int rows = this.byName.get((Object)name).size();
            if (rows > 1) {
                name = name + " (" + rows + ')';
            }
            while (name.length() > 2 && this.field_146289_q.func_78256_a(name) > 155) {
                name = name.substring(0, name.length() - 1);
            }
            this.field_146289_q.func_78276_b(name, this.offsetX + 2, 5 + offset, 0x404040);
            ++linesDraw;
            offset += 18;
        }
        if (this.searchFieldInputs.isMouseIn(mouseX, mouseY)) {
            this.drawTooltip(Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - offsetX, mouseY - this.field_147009_r, "Inputs OR names");
        }
    }

    protected void func_73864_a(int xCoord, int yCoord, int btn) throws IOException {
        this.searchFieldInputs.func_146192_a(xCoord, yCoord, btn);
        if (btn == 1 && this.searchFieldInputs.isMouseIn(xCoord, yCoord)) {
            this.searchFieldInputs.func_146180_a("");
            this.refreshList();
        }
        for (GuiCustomSlot slot : this.guiSlots) {
            if (!(slot instanceof SlotGasTank) || !this.func_146978_c(slot.xPos(), slot.yPos(), slot.getWidth(), slot.getHeight(), xCoord, yCoord) || !slot.canClick((EntityPlayer)this.field_146297_k.field_71439_g)) continue;
            NetworkHandler.instance().sendToServer((AppEngPacket)new PacketInventoryAction(InventoryAction.PICKUP_OR_SET_DOWN, slot.getId(), this.guiGasTankClientDCInternalGasInvMap.get(slot).getId()));
            return;
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_146284_a(@Nonnull GuiButton btn) throws IOException {
        if (this.guiButtonHashMap.containsKey(btn)) {
            int interfaceDim;
            BlockPos blockPos = this.blockPosHashMap.get(this.guiButtonHashMap.get(this.field_146290_a));
            BlockPos blockPos2 = this.field_146297_k.field_71439_g.func_180425_c();
            int playerDim = this.field_146297_k.field_71441_e.field_73011_w.getDimension();
            if (playerDim != (interfaceDim = this.dimHashMap.get(this.guiButtonHashMap.get(this.field_146290_a)).intValue())) {
                try {
                    this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Gas interface located at dimension: " + interfaceDim + " [" + DimensionManager.getWorld((int)interfaceDim).field_73011_w.func_186058_p().func_186065_b() + "] and cant be highlighted"), false);
                }
                catch (Exception e) {
                    this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Gas interface is located in another dimension and cannot be highlighted"), false);
                }
            } else {
                BlockPosHighlighter.hilightBlock((BlockPos)blockPos, (long)(System.currentTimeMillis() + 500L * BlockPosUtils.getDistance((BlockPos)blockPos, (BlockPos)blockPos2)), (int)playerDim);
                this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("The gas interface is now highlighted at X: " + blockPos.func_177958_n() + " Y: " + blockPos.func_177956_o() + " Z: " + blockPos.func_177952_p()), false);
            }
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/interfaceconfigurationterminal.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
        int offset = 29;
        int ex = this.getScrollBar().getCurrentScroll();
        int linesDraw = 0;
        for (int x = 0; x < 6 && linesDraw < 6 && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalGasInv) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int width = 162;
                int extraLines = this.numUpgradesMap.get(lineObj);
                for (int row = 0; row < 1 + extraLines && linesDraw < 6; ++linesDraw, ++row) {
                    this.func_73729_b(offsetX + 20, offsetY + offset, 20, 170, 162, 18);
                    offset += 18;
                }
                continue;
            }
            offset += 18;
            ++linesDraw;
        }
        if (this.searchFieldInputs != null) {
            this.searchFieldInputs.func_146194_f();
        }
    }

    protected void func_73869_a(char character, int key) throws IOException {
        if (!this.func_146983_a(key)) {
            if (character == ' ' && this.searchFieldInputs.func_146179_b().isEmpty() && this.searchFieldInputs.func_146206_l()) {
                return;
            }
            if (this.searchFieldInputs.func_146201_a(character, key)) {
                this.refreshList();
            } else {
                super.func_73869_a(character, key);
            }
        }
    }

    public void postUpdate(NBTTagCompound in) {
        if (in.func_74767_n("clear")) {
            this.byId.clear();
            this.refreshList = true;
        }
        for (String oKey : in.func_150296_c()) {
            if (!oKey.startsWith("=")) continue;
            try {
                long id = Long.parseLong(oKey.substring(1), 36);
                NBTTagCompound invData = in.func_74775_l(oKey);
                ClientDCInternalGasInv current = this.getById(id, invData.func_74763_f("sortBy"), invData.func_74779_i("un"));
                this.blockPosHashMap.put(current, NBTUtil.func_186861_c((NBTTagCompound)invData.func_74775_l("pos")));
                this.dimHashMap.put(current, invData.func_74762_e("dim"));
                this.numUpgradesMap.put(current, invData.func_74762_e("numUpgrades"));
                for (int x = 0; x < current.getInventory().size(); ++x) {
                    String which = Integer.toString(x);
                    if (!invData.func_74764_b(which)) continue;
                    current.getInventory().setGas(x, GasStack.readFromNBT((NBTTagCompound)invData.func_74775_l(which)));
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        if (this.refreshList) {
            this.refreshList = false;
            this.cachedSearches.clear();
            this.refreshList();
        }
    }

    private void refreshList() {
        this.byName.clear();
        this.field_146292_n.clear();
        this.matchedStacks.clear();
        this.matchedInterfaces.clear();
        String searchFieldInputs = this.searchFieldInputs.func_146179_b().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm(searchFieldInputs);
        boolean rebuild = cachedSearch.isEmpty();
        for (ClientDCInternalGasInv entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFieldInputs.isEmpty();
            if (!found) {
                int slot = 0;
                for (int i = 0; i < entry.getInventory().size() && slot <= 8 + this.numUpgradesMap.get(entry) * 9; ++slot, ++i) {
                    GasStack gs = entry.getInventory().getGasStack(i);
                    if (!this.gasStackMatchesSearchTerm(gs, searchFieldInputs)) continue;
                    found = true;
                    this.matchedStacks.add(gs);
                }
            }
            if (searchFieldInputs.isEmpty() || entry.getName().toLowerCase().contains(searchFieldInputs)) {
                this.matchedInterfaces.add(entry);
                found = true;
            }
            if (found) {
                this.byName.put((Object)entry.getName(), (Object)entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.names.clear();
        this.names.addAll(this.byName.keySet());
        Collections.sort(this.names);
        this.lines.clear();
        this.lines.ensureCapacity(this.getMaxRows());
        for (String n : this.names) {
            this.lines.add(n);
            ArrayList clientInventories = new ArrayList();
            clientInventories.addAll(this.byName.get((Object)n));
            Collections.sort(clientInventories);
            this.lines.addAll(clientInventories);
        }
        this.getScrollBar().setRange(0, this.lines.size() - 1, 1);
    }

    private boolean gasStackMatchesSearchTerm(GasStack gasStack, String searchTerm) {
        if (gasStack == null) {
            return false;
        }
        boolean foundMatchingGasStack = false;
        String displayName = Utils.getGasDisplayName(gasStack).toLowerCase();
        for (String term : searchTerm.split(" ")) {
            if (term.length() > 1 && (term.startsWith("-") || term.startsWith("!"))) {
                if (!displayName.contains(term = term.substring(1))) continue;
                return false;
            }
            if (displayName.contains(term)) {
                foundMatchingGasStack = true;
                continue;
            }
            return false;
        }
        return foundMatchingGasStack;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
            return cache;
        }
        return cache;
    }

    private int getMaxRows() {
        return this.names.size() + this.byId.size();
    }

    private ClientDCInternalGasInv getById(long id, long sortBy, String string) {
        ClientDCInternalGasInv o = this.byId.get(id);
        if (o == null) {
            o = new ClientDCInternalGasInv(9, id, sortBy, string, 1000);
            this.byId.put(id, o);
            this.refreshList = true;
        }
        return o;
    }

    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        GasStack gas = null;
        if (ingredient instanceof GasStack) {
            gas = (GasStack)ingredient;
        } else if (ingredient instanceof ItemStack) {
            gas = Utils.getGasFromItem((ItemStack)ingredient);
        }
        if (gas != null) {
            final GasStack imGas = gas;
            this.mapTargetSlot.clear();
            ArrayList targets = new ArrayList();
            ArrayList<SlotGasTank> slots = new ArrayList<SlotGasTank>();
            if (!this.getGuiSlots().isEmpty()) {
                for (final SlotGasTank slot : this.getGuiSlots()) {
                    if (!(slot instanceof SlotGasTank)) continue;
                    slots.add(slot);
                }
            }
            for (final SlotGasTank slot : slots) {
                IGhostIngredientHandler.Target<Object> targetItem = new IGhostIngredientHandler.Target<Object>(){

                    @Nonnull
                    public Rectangle getArea() {
                        if (slot.isSlotEnabled()) {
                            return new Rectangle(GuiGasInterfaceConfigurationTerminal.this.getGuiLeft() + slot.xPos(), GuiGasInterfaceConfigurationTerminal.this.getGuiTop() + slot.yPos(), 16, 16);
                        }
                        return new Rectangle();
                    }

                    public void accept(@Nonnull Object o) {
                        MekEng.proxy.netHandler.sendToServer((IMessage)new CGenericPacket("jei_set", slot.getId(), ((ClientDCInternalGasInv)GuiGasInterfaceConfigurationTerminal.this.guiGasTankClientDCInternalGasInvMap.get((Object)slot)).getId(), AEGasStack.of(imGas)));
                    }
                };
                targets.add(targetItem);
                this.mapTargetSlot.putIfAbsent(targetItem, (Object)slot);
            }
            return targets;
        }
        return new ArrayList();
    }

    public Map<IGhostIngredientHandler.Target<?>, Object> getFakeSlotTargetMap() {
        return this.mapTargetSlot;
    }

    @Override
    @Nonnull
    public Map<String, Consumer<Paras>> getActionMap() {
        return this.holder;
    }
}

