/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.client.gui;

import appeng.api.config.Settings;
import appeng.api.storage.ITerminalHost;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.gui.AEBaseMEGui;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.core.localization.GuiText;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.InventoryAction;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import com.mekeng.github.MekEng;
import com.mekeng.github.client.render.GasStackSizeRenderer;
import com.mekeng.github.client.slots.SlotGasME;
import com.mekeng.github.common.container.ContainerGasTerminal;
import com.mekeng.github.common.me.client.GasRepo;
import com.mekeng.github.common.me.client.RepoSlot;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.network.packet.CGenericPacket;
import com.mekeng.github.util.Utils;
import java.awt.Rectangle;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import mekanism.api.gas.Gas;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiGasTerminal
extends AEBaseMEGui
implements ISortSource,
IConfigManagerHost {
    private final List<SlotGasME> meGasSlots = new LinkedList<SlotGasME>();
    private final GasRepo repo;
    private final IConfigManager configSrc;
    private final ContainerGasTerminal container;
    private final GasStackSizeRenderer gasStackSizeRenderer = new GasStackSizeRenderer();
    private final int offsetX = 9;
    private final int rows = 6;
    private final int perRow = 9;
    protected ITerminalHost terminal;
    private MEGuiTextField searchField;
    private GuiImgButton sortByBox;
    private GuiImgButton sortDirBox;
    protected int jeiOffset = Loader.isModLoaded((String)"jei") ? 24 : 0;

    public GuiGasTerminal(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        this(inventoryPlayer, te, new ContainerGasTerminal(inventoryPlayer, te));
    }

    public GuiGasTerminal(InventoryPlayer inventoryPlayer, ITerminalHost te, ContainerGasTerminal c) {
        super((Container)c);
        this.terminal = te;
        this.field_146999_f = 190;
        this.field_147000_g = 222;
        GuiScrollbar scrollbar = new GuiScrollbar();
        this.setScrollBar(scrollbar);
        this.repo = new GasRepo((IScrollSource)scrollbar, this);
        this.configSrc = ((IConfigurableObject)this.field_147002_h).getConfigManager();
        this.container = (ContainerGasTerminal)this.field_147002_h;
        this.container.setGui(this);
    }

    protected String getName() {
        return "gui.mekeng.gas_terminal";
    }

    public void func_73866_w_() {
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.searchField = new MEGuiTextField(this.field_146289_q, this.field_147003_i + 80, this.field_147009_r + 4, 90, 12);
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(25);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.setSelectionColor(-6684775);
        this.searchField.func_146189_e(true);
        int offset = this.field_147009_r;
        this.sortByBox = new GuiImgButton(this.field_147003_i - 18, offset, (Enum)Settings.SORT_BY, this.configSrc.getSetting(Settings.SORT_BY));
        this.field_146292_n.add(this.sortByBox);
        this.sortDirBox = new GuiImgButton(this.field_147003_i - 18, offset += 20, (Enum)Settings.SORT_DIRECTION, this.configSrc.getSetting(Settings.SORT_DIRECTION));
        this.field_146292_n.add(this.sortDirBox);
        block0: for (int y = 0; y < this.rows; ++y) {
            int x = 0;
            while (true) {
                ((Object)((Object)this)).getClass();
                if (x >= 9) continue block0;
                ((Object)((Object)this)).getClass();
                ((Object)((Object)this)).getClass();
                SlotGasME slot = new SlotGasME(new RepoSlot(this.repo, x + y * 9, 9 + x * 18, 18 + y * 18));
                this.getMeGasSlots().add(slot);
                this.field_147002_h.field_75151_b.add(slot);
                ++x;
            }
        }
        this.setScrollBar();
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(I18n.func_135052_a((String)this.getName(), (Object[])new Object[0])), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 96 + 3, 0x404040);
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture(this.getBackground());
        int x_width = 197;
        this.func_73729_b(offsetX, offsetY, 0, 0, 197, 18);
        for (int x = 0; x < 6; ++x) {
            this.func_73729_b(offsetX, offsetY + 18 + x * 18, 0, 18, 197, 18);
        }
        this.func_73729_b(offsetX, offsetY + 16 + 108, 0, 70, 197, 176);
        if (this.searchField != null) {
            this.searchField.func_146194_f();
        }
    }

    public void func_146977_a(Slot s) {
        if (s instanceof SlotGasME && ((SlotGasME)s).shouldRenderAsGas()) {
            SlotGasME slot = (SlotGasME)s;
            IAEGasStack gs = slot.getAEGasStack();
            if (gs != null && this.isPowered()) {
                GlStateManager.func_179145_e();
                GlStateManager.func_179147_l();
                Gas gas = gs.getGas();
                this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                TextureAtlasSprite sprite = gas.getSprite();
                MekanismRenderer.color((Gas)gas);
                this.func_175175_a(s.field_75223_e, s.field_75221_f, sprite, 16, 16);
                MekanismRenderer.resetColor();
                this.gasStackSizeRenderer.renderStackSize(this.field_146289_q, gs, s.field_75223_e, s.field_75221_f);
            } else if (!this.isPowered()) {
                GuiGasTerminal.func_73734_a((int)s.field_75223_e, (int)s.field_75221_f, (int)(16 + s.field_75223_e), (int)(16 + s.field_75221_f), (int)0x66111111);
            }
        } else {
            super.func_146977_a(s);
        }
    }

    public void func_73876_c() {
        this.repo.setPower(this.container.isPowered());
        super.func_73876_c();
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        SlotGasME gasSlot;
        Slot slot = this.getSlot(mouseX, mouseY);
        if (slot instanceof SlotGasME && slot.func_111238_b() && (gasSlot = (SlotGasME)slot).getAEGasStack() != null && gasSlot.shouldRenderAsGas()) {
            IAEGasStack gasStack = gasSlot.getAEGasStack();
            String formattedAmount = NumberFormat.getNumberInstance(Locale.US).format((double)gasStack.getStackSize() / 1000.0) + " B";
            String modName = "" + TextFormatting.BLUE + TextFormatting.ITALIC + ((ModContainer)Loader.instance().getIndexedModList().get(Utils.getGasModID(gasStack))).getName();
            ArrayList<String> list = new ArrayList<String>();
            list.add(gasStack.getGas().getLocalizedName());
            list.add(formattedAmount);
            list.add(modName);
            this.func_146283_a(list, mouseX, mouseY);
            return;
        }
        super.func_191948_b(mouseX, mouseY);
    }

    protected void func_146284_a(@Nonnull GuiButton btn) {
        if (btn instanceof GuiImgButton) {
            boolean backwards = Mouse.isButtonDown((int)1);
            GuiImgButton iBtn = (GuiImgButton)btn;
            if (iBtn.getSetting() != Settings.ACTIONS) {
                Enum cv = iBtn.getCurrentValue();
                Enum next = Platform.rotateEnum((Enum)cv, (boolean)backwards, (EnumSet)iBtn.getSetting().getPossibleValues());
                try {
                    NetworkHandler.instance().sendToServer((AppEngPacket)new PacketValueConfig(iBtn.getSetting().name(), next.name()));
                }
                catch (IOException e) {
                    MekEng.log.debug((Object)e);
                }
                iBtn.set(next);
            }
        }
    }

    protected void func_184098_a(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof SlotGasME) {
            SlotGasME meSlot = (SlotGasME)slot;
            if (clickType == ClickType.PICKUP) {
                if (mouseButton == 0 && meSlot.func_75216_d()) {
                    this.container.setTargetGasStack(meSlot.getAEGasStack());
                    MekEng.proxy.netHandler.sendToServer((IMessage)new CGenericPacket("set_target", meSlot.getAEGasStack()));
                    MekEng.log.debug("mouse0 GUI STACK SIZE %s", (Object)meSlot.getAEGasStack().getStackSize());
                    NetworkHandler.instance().sendToServer((AppEngPacket)new PacketInventoryAction(InventoryAction.FILL_ITEM, slot.field_75222_d, 0L));
                } else {
                    this.container.setTargetGasStack(meSlot.getAEGasStack());
                    MekEng.proxy.netHandler.sendToServer((IMessage)new CGenericPacket("set_target", meSlot.getAEGasStack()));
                    if (meSlot.getAEGasStack() != null) {
                        MekEng.log.debug("mouse1 GUI STACK SIZE %s", (Object)meSlot.getAEGasStack().getStackSize());
                    }
                    NetworkHandler.instance().sendToServer((AppEngPacket)new PacketInventoryAction(InventoryAction.EMPTY_ITEM, slot.field_75222_d, 0L));
                }
            }
            return;
        }
        super.func_184098_a(slot, slotIdx, mouseButton, clickType);
    }

    protected void func_73869_a(char character, int key) throws IOException {
        if (!this.func_146983_a(key)) {
            if (character == ' ' && this.searchField.func_146179_b().isEmpty()) {
                return;
            }
            if (this.searchField.func_146201_a(character, key)) {
                this.repo.setSearchString(this.searchField.func_146179_b());
                this.repo.updateView();
                this.setScrollBar();
            } else {
                super.func_73869_a(character, key);
            }
        }
    }

    protected void func_73864_a(int xCoord, int yCoord, int btn) throws IOException {
        this.searchField.func_146192_a(xCoord, yCoord, btn);
        if (btn == 1 && this.searchField.isMouseIn(xCoord, yCoord)) {
            this.searchField.func_146180_a("");
            this.repo.setSearchString("");
            this.repo.updateView();
            this.setScrollBar();
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    public void postUpdate(List<IAEGasStack> list) {
        for (IAEGasStack is : list) {
            this.repo.postUpdate(is);
        }
        this.repo.updateView();
        this.setScrollBar();
    }

    private void setScrollBar() {
        this.getScrollBar().setTop(18).setLeft(175).setHeight(this.rows * 18 - 2);
        GuiScrollbar guiScrollbar = this.getScrollBar();
        int n = this.repo.size();
        ((Object)((Object)this)).getClass();
        int n2 = n + 9 - 1;
        ((Object)((Object)this)).getClass();
        guiScrollbar.setRange(0, n2 / 9 - this.rows, Math.max(1, this.rows / 6));
    }

    public Enum<?> getSortBy() {
        return this.configSrc.getSetting(Settings.SORT_BY);
    }

    public Enum<?> getSortDir() {
        return this.configSrc.getSetting(Settings.SORT_DIRECTION);
    }

    public Enum<?> getSortDisplay() {
        return this.configSrc.getSetting(Settings.VIEW_MODE);
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.sortByBox != null) {
            this.sortByBox.set(this.configSrc.getSetting(Settings.SORT_BY));
        }
        if (this.sortDirBox != null) {
            this.sortDirBox.set(this.configSrc.getSetting(Settings.SORT_DIRECTION));
        }
        this.repo.updateView();
    }

    protected List<SlotGasME> getMeGasSlots() {
        return this.meGasSlots;
    }

    protected boolean isPowered() {
        return this.repo.hasPower();
    }

    protected String getBackground() {
        return "guis/terminal.png";
    }

    public List<Rectangle> getJEIExclusionArea() {
        ArrayList<Rectangle> exclusionArea = new ArrayList<Rectangle>();
        int yOffset = this.field_147009_r + 8 + this.jeiOffset;
        int visibleButtons = 2;
        Rectangle sortDir = new Rectangle(this.field_147003_i - 18, yOffset, 20, visibleButtons * 20 + visibleButtons - 2);
        exclusionArea.add(sortDir);
        return exclusionArea;
    }
}

