/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.client.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mekeng.github.common.ItemAndBlocks;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.common.MekanismFluids;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class DummyGasModel
implements IModel {
    protected static final ItemCameraTransforms CAMERA_TRANSFORMS = new ItemCameraTransforms(new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0625f), new Vector3f(0.55f, 0.55f, 0.55f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0625f), new Vector3f(0.55f, 0.55f, 0.55f)), new ItemTransformVec3f(new Vector3f(0.0f, -90.0f, 25.0f), new Vector3f(0.070625f, 0.2f, 0.070625f), new Vector3f(0.68f, 0.68f, 0.68f)), new ItemTransformVec3f(new Vector3f(0.0f, -90.0f, 25.0f), new Vector3f(0.070625f, 0.2f, 0.070625f), new Vector3f(0.68f, 0.68f, 0.68f)), new ItemTransformVec3f(new Vector3f(0.0f, 180.0f, 0.0f), new Vector3f(0.0f, 0.8125f, 0.4375f), new Vector3f(1.0f, 1.0f, 1.0f)), ItemTransformVec3f.field_178366_a, new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.125f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)), new ItemTransformVec3f(new Vector3f(0.0f, 180.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)));

    @Nonnull
    public IBakedModel bake(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> textureBakery) {
        return new BakedGasModel(state, format);
    }

    protected static class BakedGasModel
    implements IBakedModel {
        protected final Optional<TRSRTransformation> modelTransform;
        protected final VertexFormat vertexFormat;
        protected final ItemOverrideList overrides;
        private final IBakedModel defaultOverride;

        public BakedGasModel(IModelState modelState, VertexFormat vertexFormat) {
            this.modelTransform = modelState.apply(Optional.empty());
            this.vertexFormat = vertexFormat;
            this.overrides = this.genOverrides();
            this.defaultOverride = this.genDefaultOverrides();
        }

        @Nonnull
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return this.defaultOverride.func_188616_a(state, side, rand);
        }

        public boolean func_177555_b() {
            return this.defaultOverride.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.defaultOverride.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.defaultOverride.func_188618_c();
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return this.defaultOverride.func_177554_e();
        }

        public boolean isAmbientOcclusion(@Nonnull IBlockState state) {
            return this.defaultOverride.isAmbientOcclusion(state);
        }

        @Nonnull
        public ItemCameraTransforms func_177552_f() {
            return this.defaultOverride.func_177552_f();
        }

        @Nonnull
        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
            return this.defaultOverride.handlePerspective(cameraTransformType);
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }

        protected ItemOverrideList genOverrides() {
            return new OverrideCache();
        }

        protected IBakedModel genDefaultOverrides() {
            return ((OverrideCache)this.overrides).resolve(new GasStack(MekanismFluids.Hydrogen, 1000));
        }

        private class OverrideCache
        extends ItemOverrideList {
            private final Cache<Gas, OverrideModel> cache;

            OverrideCache() {
                super(Collections.emptyList());
                this.cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
            }

            @Nonnull
            public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (stack.func_77973_b() != ItemAndBlocks.DUMMY_GAS) {
                    return originalModel;
                }
                GasStack gas = ItemAndBlocks.DUMMY_GAS.getGasStack(stack);
                return gas != null ? this.resolve(gas) : originalModel;
            }

            OverrideModel resolve(GasStack gas) {
                try {
                    return (OverrideModel)this.cache.get((Object)gas.getGas(), () -> new OverrideModel(gas));
                }
                catch (ExecutionException e) {
                    throw new IllegalStateException(e);
                }
            }

            class OverrideModel
            implements IBakedModel {
                private final TextureAtlasSprite texture;
                private final List<BakedQuad> quads;

                OverrideModel(GasStack gasStack) {
                    this.texture = gasStack.getGas().getSprite();
                    this.quads = ItemLayerModel.getQuadsForSprite((int)1, (TextureAtlasSprite)this.texture, (VertexFormat)BakedGasModel.this.vertexFormat, BakedGasModel.this.modelTransform);
                }

                @Nonnull
                public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
                    return this.quads;
                }

                public boolean func_177555_b() {
                    return false;
                }

                public boolean func_177556_c() {
                    return false;
                }

                public boolean func_188618_c() {
                    return false;
                }

                @Nonnull
                public TextureAtlasSprite func_177554_e() {
                    return this.texture;
                }

                @Nonnull
                public ItemCameraTransforms func_177552_f() {
                    return CAMERA_TRANSFORMS;
                }

                @Nonnull
                public ItemOverrideList func_188617_f() {
                    return OverrideCache.this;
                }
            }
        }
    }

    public static class Loader
    implements ICustomModelLoader {
        public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.compareTo(ItemAndBlocks.DUMMY_GAS.getModelPath()) == 0;
        }

        @Nonnull
        public IModel loadModel(@Nonnull ResourceLocation modelLocation) {
            return new DummyGasModel();
        }
    }
}

