/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.client.slots;

import appeng.client.gui.widgets.GuiCustomSlot;
import appeng.container.slot.IJEITargetSlot;
import com.mekeng.github.MekEng;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.inventory.IGasInventory;
import com.mekeng.github.network.packet.CGasSlotSync;
import com.mekeng.github.util.Utils;
import java.util.Collections;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SlotGas
extends GuiCustomSlot
implements IJEITargetSlot {
    private final IGasInventory gases;
    private final int slot;

    public SlotGas(IGasInventory gases, int slot, int id, int x, int y) {
        super(id, x, y);
        this.gases = gases;
        this.slot = slot;
    }

    public void drawContent(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        GasStack gs = this.getGasStack();
        if (gs != null) {
            GlStateManager.func_179145_e();
            GlStateManager.func_179147_l();
            Gas gas = gs.getGas();
            mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            TextureAtlasSprite sprite = gas.getSprite();
            MekanismRenderer.color((Gas)gas);
            this.func_175175_a(this.xPos(), this.yPos(), sprite, this.getWidth(), this.getHeight());
            MekanismRenderer.resetColor();
        }
    }

    public boolean canClick(EntityPlayer player) {
        ItemStack mouseStack = player.field_71071_by.func_70445_o();
        return mouseStack.func_190926_b() || Utils.getGasHandler(mouseStack) != null;
    }

    public void slotClicked(ItemStack clickStack, int mouseButton) {
        GasStack gas;
        if (clickStack.func_190926_b() || mouseButton == 1) {
            this.setGasStack(null);
        } else if (mouseButton == 0 && (gas = Utils.getGasFromItem(clickStack)) != null) {
            this.setGasStack(gas);
        }
    }

    public String getMessage() {
        GasStack gas = this.getGasStack();
        if (gas != null) {
            return gas.getGas().getLocalizedName();
        }
        return null;
    }

    public boolean isVisible() {
        return true;
    }

    public GasStack getGasStack() {
        return this.gases.getGasStack(this.slot);
    }

    public void setGasStack(GasStack stack) {
        this.gases.setGas(this.slot, stack);
        MekEng.proxy.netHandler.sendToServer((IMessage)new CGasSlotSync(Collections.singletonMap(this.getId(), AEGasStack.of(stack))));
    }

    public boolean needAccept() {
        return this.getGasStack() == null;
    }
}

