/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.client.slots;

import appeng.client.gui.widgets.GuiCustomSlot;
import appeng.client.gui.widgets.ITooltip;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.helpers.InventoryAction;
import com.mekeng.github.common.me.inventory.IGasInventory;
import mekanism.api.gas.GasStack;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SlotGasTank
extends GuiCustomSlot
implements ITooltip {
    private final IGasInventory tank;
    private final int slot;
    private final int width;
    private final int height;
    private boolean darkened = false;

    public SlotGasTank(IGasInventory tank, int slot, int id, int x, int y, int w, int h) {
        super(id, x, y);
        this.tank = tank;
        this.slot = slot;
        this.width = w;
        this.height = h;
    }

    public SlotGasTank(IGasInventory tank, int slot, int id, int x, int y, int w, int h, boolean darkened) {
        super(id, x, y);
        this.tank = tank;
        this.slot = slot;
        this.width = w;
        this.height = h;
        this.darkened = darkened;
    }

    public void drawContent(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        GasStack fs = this.getGasStack();
        if (fs != null) {
            GlStateManager.func_179145_e();
            GlStateManager.func_179147_l();
            GasStack gas = this.tank.getGasStack(this.slot);
            if (gas != null && gas.amount > 0) {
                mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                float red = (float)(gas.getGas().getTint() >> 16 & 0xFF) / 255.0f;
                float green = (float)(gas.getGas().getTint() >> 8 & 0xFF) / 255.0f;
                float blue = (float)(gas.getGas().getTint() & 0xFF) / 255.0f;
                if (this.darkened) {
                    red *= 0.4f;
                    green *= 0.4f;
                    blue *= 0.4f;
                }
                GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
                TextureAtlasSprite sprite = gas.getGas().getSprite();
                int scaledHeight = (int)((float)this.height * ((float)gas.amount / (float)this.tank.getTanks()[this.slot].getMaxGas()));
                scaledHeight = Math.min(this.height, scaledHeight);
                int iconHeightRemainder = scaledHeight % 16;
                if (iconHeightRemainder > 0) {
                    this.func_175175_a(this.xPos(), this.yPos() + this.getHeight() - iconHeightRemainder, sprite, 16, iconHeightRemainder);
                }
                for (int i = 0; i < scaledHeight / 16; ++i) {
                    this.func_175175_a(this.xPos(), this.yPos() + this.getHeight() - iconHeightRemainder - (i + 1) * 16, sprite, 16, 16);
                }
                MekanismRenderer.resetColor();
            }
        }
    }

    public String getMessage() {
        GasStack gas = this.tank.getGasStack(this.slot);
        if (gas != null && gas.amount > 0) {
            String desc = gas.getGas().getLocalizedName();
            return desc + "\n" + gas.amount + "/" + this.tank.getTanks()[this.slot].getMaxGas() + "mB";
        }
        return null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isVisible() {
        return true;
    }

    public GasStack getGasStack() {
        return this.tank.getGasStack(this.slot);
    }

    public void slotClicked(ItemStack clickStack, int mouseButton) {
        if (this.getGasStack() != null) {
            NetworkHandler.instance().sendToServer((AppEngPacket)new PacketInventoryAction(InventoryAction.FILL_ITEM, this.slot, (long)this.id));
        } else {
            NetworkHandler.instance().sendToServer((AppEngPacket)new PacketInventoryAction(InventoryAction.EMPTY_ITEM, this.slot, (long)this.id));
        }
    }
}

