/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.container;

import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.util.Platform;
import com.mekeng.github.common.container.sync.IGasSyncContainer;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.inventory.IGasInventory;
import com.mekeng.github.network.packet.sync.IActionHolder;
import com.mekeng.github.network.packet.sync.Paras;
import com.mekeng.github.util.Utils;
import com.mekeng.github.util.helpers.GasSyncHelper;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;

public abstract class ContainerGasConfigurable<T extends IUpgradeableHost>
extends ContainerUpgradeable
implements IGasSyncContainer,
IActionHolder {
    protected final GasSyncHelper sync = GasSyncHelper.create(this.getGasConfigInventory(), 0);
    protected final Map<String, Consumer<Paras>> holder = this.createHolder();

    public ContainerGasConfigurable(InventoryPlayer ip, T te) {
        super(ip, te);
        this.holder.put("jei_set", o -> {
            AEGasStack gas = (AEGasStack)o.get(1);
            if (gas != null) {
                gas.setStackSize(1000L);
                this.getGasConfigInventory().setGas((Integer)o.get(0), gas.getGasStack());
                this.receiveGasSlots(Collections.singletonMap(o.get(0), gas));
            }
        });
    }

    protected T getUpgradeable() {
        return (T)super.getUpgradeable();
    }

    public abstract IGasInventory getGasConfigInventory();

    protected ItemStack transferStackToContainer(ItemStack input) {
        GasStack gs = Utils.getGasFromItem(input);
        if (gs != null) {
            IGasInventory t = this.getGasConfigInventory();
            AEGasStack stack = AEGasStack.of(gs);
            for (int i = 0; i < t.size(); ++i) {
                if (t.getGasStack(i) != null || !this.isValidForConfig(i, stack)) continue;
                t.setGas(i, stack == null ? null : stack.getGasStack());
                break;
            }
        }
        return input;
    }

    protected boolean isValidForConfig(int slot, @Nullable IAEGasStack gs) {
        if (this.supportCapacity()) {
            int upgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
            if (slot > 0 && upgrades < 1) {
                return false;
            }
            return slot <= 4 || upgrades >= 2;
        }
        return true;
    }

    protected void standardDetectAndSendChanges() {
        if (Platform.isServer()) {
            this.sync.sendDiff(this.field_75149_d);
            IGasInventory t = this.getGasConfigInventory();
            for (int i = 0; i < t.size(); ++i) {
                if (t.getGasStack(i) == null || this.isValidForConfig(i, AEGasStack.of(t.getGasStack(i)))) continue;
                t.setGas(i, null);
            }
        }
        super.standardDetectAndSendChanges();
    }

    public void func_75132_a(@Nonnull IContainerListener listener) {
        super.func_75132_a(listener);
        this.sync.sendFull(Collections.singleton(listener));
    }

    @Override
    public void receiveGasSlots(Map<Integer, IAEGasStack> gases) {
        this.sync.readPacket(gases);
    }

    @Override
    @Nonnull
    public Map<String, Consumer<Paras>> getActionMap() {
        return this.holder;
    }
}

