/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.container;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Upgrades;
import appeng.api.util.IConfigManager;
import appeng.container.guisync.GuiSync;
import appeng.helpers.InventoryAction;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import com.mekeng.github.common.container.ContainerGasConfigurable;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.duality.IGasInterfaceHost;
import com.mekeng.github.common.me.duality.impl.DualityGasInterface;
import com.mekeng.github.common.me.inventory.IGasInventory;
import com.mekeng.github.util.Utils;
import com.mekeng.github.util.helpers.GasSyncHelper;
import com.mekeng.github.util.helpers.ItemGasHandler;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;

public class ContainerGasInterface
extends ContainerGasConfigurable<IGasInterfaceHost>
implements IConfigManagerHost {
    private final DualityGasInterface myDuality;
    private final GasSyncHelper tankSync;
    private IConfigManagerHost gui;
    private IAEGasStack clientRequestedTargetGas = null;
    @GuiSync(value=7)
    public int capacityUpgrades = 0;

    public ContainerGasInterface(InventoryPlayer ip, IGasInterfaceHost te) {
        super(ip, te);
        this.myDuality = te.getDualityGasInterface();
        this.tankSync = GasSyncHelper.create(this.myDuality.getTanks(), 9);
        this.holder.put("set_target", o -> this.setTargetGasStack((IAEGasStack)o.get(0)));
    }

    protected int getHeight() {
        return 231;
    }

    @Override
    public IGasInventory getGasConfigInventory() {
        return ((IGasInterfaceHost)this.getUpgradeable()).getDualityGasInterface().getConfig();
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.tankSync.sendDiff(this.field_75149_d);
            if (this.capacityUpgrades != ((IGasInterfaceHost)this.getUpgradeable()).getInstalledUpgrades(Upgrades.CAPACITY)) {
                this.capacityUpgrades = ((IGasInterfaceHost)this.getUpgradeable()).getInstalledUpgrades(Upgrades.CAPACITY);
            }
        }
        super.func_75142_b();
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        if (Platform.isClient() && field.equals("capacityUpgrades")) {
            this.capacityUpgrades = (Integer)newValue;
            this.myDuality.getTanks().setCap((int)(Math.pow(4.0, this.capacityUpgrades + 1) * 1000.0));
        }
    }

    protected void setupConfig() {
        this.setupUpgrades();
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
    }

    @Override
    public void func_75132_a(@Nonnull IContainerListener listener) {
        super.func_75132_a(listener);
        this.tankSync.sendFull(Collections.singleton(listener));
    }

    @Override
    public void receiveGasSlots(Map<Integer, IAEGasStack> gases) {
        super.receiveGasSlots(gases);
        if (Platform.isClient()) {
            this.tankSync.readPacket(gases);
        }
    }

    private IConfigManagerHost getGui() {
        return this.gui;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        if (action != InventoryAction.FILL_ITEM && action != InventoryAction.EMPTY_ITEM) {
            super.doAction(player, action, slot, id);
            return;
        }
        ItemStack held = player.field_71071_by.func_70445_o();
        ItemStack heldCopy = held.func_77946_l();
        heldCopy.func_190920_e(1);
        ItemGasHandler gh = Utils.getItemGasHandler(heldCopy);
        if (gh == null) {
            return;
        }
        if (action == InventoryAction.FILL_ITEM && this.clientRequestedTargetGas != null) {
            IAEGasStack stack = (IAEGasStack)this.clientRequestedTargetGas.copy();
            stack.setStackSize(Integer.MAX_VALUE);
            int amountAllowed = gh.addGas(stack.getGasStack(), false);
            int heldAmount = held.func_190916_E();
            for (int i = 0; i < heldAmount; ++i) {
                ItemStack copiedGasContainer = held.func_77946_l();
                copiedGasContainer.func_190920_e(1);
                gh = Utils.getItemGasHandler(copiedGasContainer);
                GasStack extractableGas = this.myDuality.getTankHandler().drawGas(null, ((IAEGasStack)stack.setStackSize(amountAllowed)).getGasStack(), false);
                if (extractableGas != null && extractableGas.amount != 0) {
                    int fillableAmount = gh.addGas(extractableGas, false);
                    if (fillableAmount > 0) {
                        GasStack extractedGas = this.myDuality.getTankHandler().drawGas(null, extractableGas, true);
                        gh.addGas(extractedGas, true);
                    }
                    if (held.func_190916_E() == 1) {
                        player.field_71071_by.func_70437_b(gh.getContainer());
                        continue;
                    }
                    player.field_71071_by.func_70445_o().func_190918_g(1);
                    if (player.field_71071_by.func_70441_a(gh.getContainer())) continue;
                    player.func_71019_a(gh.getContainer(), false);
                    continue;
                }
                break;
            }
        } else if (action == InventoryAction.EMPTY_ITEM) {
            int heldAmount = held.func_190916_E();
            for (int i = 0; i < heldAmount; ++i) {
                ItemStack copiedGasContainer = held.func_77946_l();
                copiedGasContainer.func_190920_e(1);
                gh = Utils.getItemGasHandler(copiedGasContainer);
                GasStack drainable = gh.removeGas(this.myDuality.getTanks().getTanks()[slot].getMaxGas(), false);
                if (drainable != null) {
                    gh.removeGas(drainable, true);
                    this.myDuality.getTankHandler().receiveGas(null, drainable, true);
                }
                if (held.func_190916_E() == 1) {
                    player.field_71071_by.func_70437_b(gh.getContainer());
                    continue;
                }
                player.field_71071_by.func_70445_o().func_190918_g(1);
                if (player.field_71071_by.func_70441_a(gh.getContainer())) continue;
                player.func_71019_a(gh.getContainer(), false);
            }
        }
        this.updateHeld(player);
    }

    public void setTargetGasStack(IAEGasStack stack) {
        if (Platform.isClient()) {
            if (stack == null && this.clientRequestedTargetGas == null) {
                return;
            }
            if (stack != null && this.clientRequestedTargetGas != null && stack.getGasStack().isGasEqual(this.clientRequestedTargetGas.getGasStack())) {
                return;
            }
        }
        this.clientRequestedTargetGas = stack == null ? null : (IAEGasStack)stack.copy();
    }

    protected boolean supportCapacity() {
        return false;
    }

    public int availableUpgrades() {
        return 2;
    }
}

