/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.container;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.container.AEBaseContainer;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import com.mekeng.github.MekEng;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.duality.IGasInterfaceHost;
import com.mekeng.github.common.me.duality.impl.DualityGasInterface;
import com.mekeng.github.common.me.inventory.IGasInventory;
import com.mekeng.github.common.me.inventory.impl.GasInventory;
import com.mekeng.github.common.part.PartGasInterface;
import com.mekeng.github.common.part.PartGasInterfaceConfigurationTerminal;
import com.mekeng.github.common.tile.TileGasInterface;
import com.mekeng.github.network.packet.SGenericPacket;
import com.mekeng.github.network.packet.sync.IActionHolder;
import com.mekeng.github.network.packet.sync.Paras;
import com.mekeng.github.util.Utils;
import com.mekeng.github.util.helpers.ItemGasHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerGasInterfaceConfigurationTerminal
extends AEBaseContainer
implements IActionHolder {
    private static long autoBase = Long.MIN_VALUE;
    private final Map<IGasInterfaceHost, GasConfigTracker> diList = new HashMap<IGasInterfaceHost, GasConfigTracker>();
    private final Map<Long, GasConfigTracker> byId = new HashMap<Long, GasConfigTracker>();
    private IGrid grid;
    private NBTTagCompound data = new NBTTagCompound();
    private final Map<String, Consumer<Paras>> holder = this.createHolder();

    public ContainerGasInterfaceConfigurationTerminal(InventoryPlayer ip, PartGasInterfaceConfigurationTerminal anchor) {
        super(ip, (Object)anchor);
        if (Platform.isServer()) {
            this.grid = anchor.getActionableNode().getGrid();
        }
        this.bindPlayerInventory(ip, 14, 153);
        this.holder.put("jei_set", o -> this.setFromJei((Integer)o.get(0), (Long)o.get(1), (IAEGasStack)o.get(2)));
    }

    public void func_75142_b() {
        IGridNode agn;
        if (Platform.isClient()) {
            return;
        }
        super.func_75142_b();
        if (this.grid == null) {
            return;
        }
        int total = 0;
        boolean missing = false;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            DualityGasInterface dual;
            GasConfigTracker t;
            IGasInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(TileGasInterface.class)) {
                if (!gn.isActive() || (ih = (IGasInterfaceHost)gn.getMachine()).getDualityGasInterface().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.diList.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getDualityGasInterface();
                    if (!t.unlocalizedName.equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
            for (IGridNode gn : this.grid.getMachines(PartGasInterface.class)) {
                if (!gn.isActive() || (ih = (IGasInterfaceHost)gn.getMachine()).getDualityGasInterface().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.diList.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getDualityGasInterface();
                    if (!t.unlocalizedName.equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
        }
        if (total != this.diList.size() || missing) {
            this.regenList(this.data);
        } else {
            for (Map.Entry<IGasInterfaceHost, GasConfigTracker> en : this.diList.entrySet()) {
                GasConfigTracker inv = en.getValue();
                for (int x = 0; x < inv.server.size(); ++x) {
                    if ((inv.server.getGasStack(x) != null || inv.client.getGasStack(x) == null) && (inv.server.getGasStack(x) == null || inv.server.getGasStack(x).equals(inv.client.getGasStack(x)))) continue;
                    this.addGases(this.data, inv, x, 1);
                }
            }
        }
        if (!this.data.func_82582_d()) {
            MekEng.proxy.netHandler.sendTo((IMessage)new SGenericPacket("update", this.data), (EntityPlayerMP)this.getPlayerInv().field_70458_d);
            this.data = new NBTTagCompound();
        }
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        GasConfigTracker inv = this.byId.get(id);
        if (inv != null) {
            ItemStack itemInHand = player.field_71071_by.func_70445_o();
            ItemGasHandler c = Utils.getItemGasHandler(itemInHand);
            if (c != null) {
                GasStack gs = c.removeGas(Integer.MAX_VALUE, false);
                if (gs != null) {
                    inv.server.setGas(slot, gs);
                    return;
                }
                return;
            }
            inv.server.setGas(slot, null);
            this.updateHeld(player);
        }
    }

    private void setFromJei(int slot, long id, IAEGasStack gas) {
        GasConfigTracker inv = this.byId.get(id);
        if (inv != null && gas != null) {
            inv.server.setGas(slot, gas.getGasStack());
        }
    }

    private void regenList(NBTTagCompound data) {
        IGridNode agn;
        this.byId.clear();
        this.diList.clear();
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            DualityGasInterface dual;
            IGasInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(TileGasInterface.class)) {
                ih = (IGasInterfaceHost)gn.getMachine();
                dual = ih.getDualityGasInterface();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.diList.put(ih, new GasConfigTracker(dual, dual.getConfig(), dual.getTermName()));
            }
            for (IGridNode gn : this.grid.getMachines(PartGasInterface.class)) {
                ih = (IGasInterfaceHost)gn.getMachine();
                dual = ih.getDualityGasInterface();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.diList.put(ih, new GasConfigTracker(dual, dual.getConfig(), dual.getTermName()));
            }
        }
        data.func_74757_a("clear", true);
        for (Map.Entry<IGasInterfaceHost, GasConfigTracker> en : this.diList.entrySet()) {
            GasConfigTracker inv = en.getValue();
            this.byId.put(inv.which, inv);
            this.addGases(data, inv, 0, inv.server.size());
        }
    }

    private void addGases(NBTTagCompound data, GasConfigTracker inv, int offset, int length) {
        String name = '=' + Long.toString(inv.which, 36);
        NBTTagCompound tag = data.func_74775_l(name);
        if (tag.func_82582_d()) {
            tag.func_74772_a("sortBy", inv.sortBy);
            tag.func_74778_a("un", inv.unlocalizedName);
            tag.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)inv.pos));
            tag.func_74768_a("dim", inv.dim);
        }
        for (int x = 0; x < length; ++x) {
            NBTTagCompound gasNBT = new NBTTagCompound();
            GasStack gasStack = inv.server.getGasStack(x + offset);
            inv.client.setGas(x + offset, gasStack == null ? null : gasStack.copy());
            if (gasStack != null) {
                gasNBT = gasStack.write(gasNBT);
            }
            tag.func_74782_a(Integer.toString(x + offset), (NBTBase)gasNBT);
        }
        data.func_74782_a(name, (NBTBase)tag);
    }

    @Override
    @Nonnull
    public Map<String, Consumer<Paras>> getActionMap() {
        return this.holder;
    }

    static /* synthetic */ long access$708() {
        return autoBase++;
    }

    public static class GasConfigTracker {
        private final long sortBy;
        private final long which = ContainerGasInterfaceConfigurationTerminal.access$708();
        private final String unlocalizedName;
        private final IGasInventory client;
        private final IGasInventory server;
        private final BlockPos pos;
        private final int dim;

        public GasConfigTracker(DualityGasInterface dual, IGasInventory configSlots, String unlocalizedName) {
            this.server = configSlots;
            this.client = new GasInventory(this.server.size());
            this.unlocalizedName = unlocalizedName;
            this.sortBy = dual.getSortValue();
            this.pos = dual.getLocation().getPos();
            this.dim = dual.getLocation().getWorld().field_73011_w.getDimension();
        }
    }
}

