/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.container;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.FuzzyMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.Upgrades;
import appeng.api.storage.data.IItemList;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.SlotRestrictedInput;
import appeng.me.storage.MEInventoryHandler;
import appeng.util.Platform;
import appeng.util.iterators.NullIterator;
import com.mekeng.github.common.container.ContainerGasConfigurable;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.inventory.IGasInventory;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import com.mekeng.github.common.part.PartGasStorageBus;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.items.IItemHandler;

public class ContainerGasStorageBus
extends ContainerGasConfigurable<PartGasStorageBus> {
    @GuiSync(value=3)
    public AccessRestriction rwMode = AccessRestriction.READ_WRITE;
    @GuiSync(value=4)
    public StorageFilter storageFilter = StorageFilter.EXTRACTABLE_ONLY;

    public ContainerGasStorageBus(InventoryPlayer ip, PartGasStorageBus te) {
        super(ip, te);
        this.holder.put("clear", o -> this.clear());
        this.holder.put("partition", o -> this.partition());
    }

    protected int getHeight() {
        return 251;
    }

    protected void setupConfig() {
        IItemHandler upgrades = ((PartGasStorageBus)this.getUpgradeable()).getInventoryByName("upgrades");
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 0, 187, 8, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 1, 187, 26, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 2, 187, 44, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 3, 187, 62, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 4, 187, 80, this.getInventoryPlayer()).setNotDraggable());
    }

    @Override
    protected boolean isValidForConfig(int slot, IAEGasStack fs) {
        if (this.supportCapacity()) {
            int y = slot / 9;
            int upgrades = ((PartGasStorageBus)this.getUpgradeable()).getInstalledUpgrades(Upgrades.CAPACITY);
            return y < upgrades + 2;
        }
        return true;
    }

    public int availableUpgrades() {
        return 5;
    }

    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.setFuzzyMode((FuzzyMode)((PartGasStorageBus)this.getUpgradeable()).getConfigManager().getSetting(Settings.FUZZY_MODE));
            this.setReadWriteMode((AccessRestriction)((PartGasStorageBus)this.getUpgradeable()).getConfigManager().getSetting(Settings.ACCESS));
            this.setStorageFilter((StorageFilter)((PartGasStorageBus)this.getUpgradeable()).getConfigManager().getSetting(Settings.STORAGE_FILTER));
        }
        this.standardDetectAndSendChanges();
    }

    public boolean isSlotEnabled(int idx) {
        int upgrades = ((PartGasStorageBus)this.getUpgradeable()).getInstalledUpgrades(Upgrades.CAPACITY);
        return upgrades > idx;
    }

    public void clear() {
        IGasInventory h = ((PartGasStorageBus)this.getUpgradeable()).getConfig();
        for (int i = 0; i < h.size(); ++i) {
            h.setGas(i, null);
        }
        this.func_75142_b();
    }

    public void partition() {
        IGasInventory h = ((PartGasStorageBus)this.getUpgradeable()).getConfig();
        MEInventoryHandler<IAEGasStack> cellInv = ((PartGasStorageBus)this.getUpgradeable()).getInternalHandler();
        Object i = new NullIterator();
        if (cellInv != null) {
            IItemList list = cellInv.getAvailableItems(((IGasStorageChannel)AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)).createList());
            i = list.iterator();
        }
        for (int x = 0; x < h.size(); ++x) {
            if (i.hasNext() && this.isSlotEnabled(x / 9 - 2)) {
                IAEGasStack gas = (IAEGasStack)i.next();
                h.setGas(x, gas == null ? null : gas.getGasStack());
                continue;
            }
            h.setGas(x, null);
        }
        this.func_75142_b();
    }

    public AccessRestriction getReadWriteMode() {
        return this.rwMode;
    }

    private void setReadWriteMode(AccessRestriction rwMode) {
        this.rwMode = rwMode;
    }

    public StorageFilter getStorageFilter() {
        return this.storageFilter;
    }

    private void setStorageFilter(StorageFilter storageFilter) {
        this.storageFilter = storageFilter;
    }

    @Override
    public IGasInventory getGasConfigInventory() {
        return ((PartGasStorageBus)this.getUpgradeable()).getConfig();
    }
}

