/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.SlotPlayerHotBar;
import appeng.container.slot.SlotPlayerInv;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.InventoryAction;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import com.mekeng.github.MekEng;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import com.mekeng.github.common.me.storage.IPortableGasCell;
import com.mekeng.github.network.packet.SMEGasInventoryUpdate;
import com.mekeng.github.network.packet.sync.IActionHolder;
import com.mekeng.github.network.packet.sync.Paras;
import com.mekeng.github.util.Utils;
import com.mekeng.github.util.helpers.ItemGasHandler;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerGasTerminal
extends AEBaseContainer
implements IConfigManagerHost,
IConfigurableObject,
IMEMonitorHandlerReceiver<IAEGasStack>,
IActionHolder {
    private final IConfigManager clientCM;
    private final IMEMonitor<IAEGasStack> monitor;
    private final IItemList<IAEGasStack> gases = ((IGasStorageChannel)AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)).createList();
    @GuiSync(value=99)
    public boolean hasPower = false;
    private final ITerminalHost terminal;
    private IConfigManager serverCM;
    private IConfigManagerHost gui;
    private IGridNode networkNode;
    private IAEGasStack clientRequestedTargetGas = null;
    private final Map<String, Consumer<Paras>> holder = this.createHolder();

    public ContainerGasTerminal(InventoryPlayer ip, ITerminalHost monitorable) {
        this(ip, monitorable, true);
    }

    public ContainerGasTerminal(InventoryPlayer ip, ITerminalHost monitorable, boolean bindInventory) {
        this(ip, monitorable, null, bindInventory);
    }

    public ContainerGasTerminal(InventoryPlayer ip, ITerminalHost terminal, IGuiItemObject guiObj, boolean bindInventory) {
        super(ip, terminal instanceof TileEntity ? (TileEntity)terminal : null, terminal instanceof IPart ? (IPart)terminal : null, guiObj);
        this.terminal = terminal;
        this.clientCM = new ConfigManager((IConfigManagerHost)this);
        this.clientCM.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        this.clientCM.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        this.holder.put("set_target", o -> this.setTargetGasStack((IAEGasStack)o.get(0)));
        if (Platform.isServer()) {
            this.serverCM = terminal.getConfigManager();
            this.monitor = terminal.getInventory(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class));
            if (this.monitor != null) {
                IGridNode node;
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                if (terminal instanceof IPortableGasCell) {
                    this.setPowerSource((IEnergySource)terminal);
                    if (terminal instanceof WirelessTerminalGuiObject) {
                        this.networkNode = ((WirelessTerminalGuiObject)terminal).getActionableNode();
                    }
                } else if (terminal instanceof IEnergySource) {
                    this.setPowerSource((IEnergySource)terminal);
                } else if ((terminal instanceof IGridHost || terminal instanceof IActionHost) && (node = terminal instanceof IGridHost ? ((IGridHost)terminal).getGridNode(AEPartLocation.INTERNAL) : ((IActionHost)terminal).getActionableNode()) != null) {
                    this.networkNode = node;
                    IGrid g = node.getGrid();
                    this.setPowerSource((IEnergySource)new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getCache(IEnergyGrid.class)));
                }
            }
        } else {
            this.monitor = null;
        }
        if (bindInventory) {
            this.bindPlayerInventory(ip, 0, 140);
        }
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void postChange(IBaseMonitor<IAEGasStack> monitor, Iterable<IAEGasStack> change, IActionSource actionSource) {
        for (IAEGasStack is : change) {
            this.gases.add((IAEStack)is);
        }
    }

    public void onListUpdate() {
        for (IContainerListener c : this.field_75149_d) {
            this.queueInventory(c);
        }
    }

    public void func_75132_a(@Nonnull IContainerListener listener) {
        super.func_75132_a(listener);
        this.queueInventory(listener);
    }

    public void func_75134_a(@Nonnull EntityPlayer player) {
        super.func_75134_a(player);
        if (this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    private void queueInventory(IContainerListener c) {
        if (Platform.isServer() && c instanceof EntityPlayer && this.monitor != null) {
            SMEGasInventoryUpdate packet = new SMEGasInventoryUpdate();
            IItemList monitorCache = this.monitor.getStorageList();
            for (IAEGasStack send : monitorCache) {
                if (packet.needFlush()) {
                    MekEng.proxy.netHandler.sendTo((IMessage)packet, (EntityPlayerMP)c);
                    packet.clear();
                }
                packet.addGas(send);
            }
            if (!packet.isEmpty()) {
                MekEng.proxy.netHandler.sendTo((IMessage)packet, (EntityPlayerMP)c);
            }
        }
    }

    public IConfigManager getConfigManager() {
        if (Platform.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public void setTargetGasStack(IAEGasStack stack) {
        if (Platform.isClient()) {
            if (stack == null && this.clientRequestedTargetGas == null) {
                return;
            }
            if (stack != null && this.clientRequestedTargetGas != null && stack.getGas() == this.clientRequestedTargetGas.getGas()) {
                return;
            }
        }
        this.clientRequestedTargetGas = stack == null ? null : (IAEGasStack)stack.copy();
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    public void func_75142_b() {
        if (Platform.isServer()) {
            if (this.monitor != this.terminal.getInventory(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class))) {
                this.setValidContainer(false);
            }
            for (Settings set : this.serverCM.getSettings()) {
                Enum sideRemote;
                Enum sideLocal = this.serverCM.getSetting(set);
                if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                this.clientCM.putSetting(set, sideLocal);
                for (IContainerListener crafter : this.field_75149_d) {
                    if (!(crafter instanceof EntityPlayerMP)) continue;
                    try {
                        NetworkHandler.instance().sendTo((AppEngPacket)new PacketValueConfig(set.name(), sideLocal.name()), (EntityPlayerMP)crafter);
                    }
                    catch (IOException e) {
                        AELog.debug((Throwable)e);
                    }
                }
            }
            if (!this.gases.isEmpty()) {
                IItemList monitorCache = this.monitor.getStorageList();
                SMEGasInventoryUpdate packet = new SMEGasInventoryUpdate();
                boolean noUpdate = true;
                for (IAEGasStack is : this.gases) {
                    IAEGasStack send;
                    if (packet.needFlush()) {
                        for (Object c : this.field_75149_d) {
                            if (!(c instanceof EntityPlayer)) continue;
                            MekEng.proxy.netHandler.sendTo((IMessage)packet, (EntityPlayerMP)c);
                        }
                        noUpdate = false;
                        packet.clear();
                    }
                    if ((send = (IAEGasStack)monitorCache.findPrecise((IAEStack)is)) == null) {
                        is.setStackSize(0L);
                        packet.addGas(is);
                        continue;
                    }
                    packet.addGas(send);
                }
                if (!packet.isEmpty()) {
                    for (Object c : this.field_75149_d) {
                        if (!(c instanceof EntityPlayer)) continue;
                        MekEng.proxy.netHandler.sendTo((IMessage)packet, (EntityPlayerMP)c);
                    }
                    noUpdate = false;
                }
                if (!noUpdate) {
                    this.gases.resetStatus();
                }
            }
            this.updatePowerStatus();
            super.func_75142_b();
        }
    }

    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        if (Platform.isClient()) {
            return ItemStack.field_190927_a;
        }
        EntityPlayerMP player = (EntityPlayerMP)p;
        if (this.field_75151_b.get(idx) instanceof SlotPlayerInv || this.field_75151_b.get(idx) instanceof SlotPlayerHotBar) {
            AppEngSlot clickSlot = (AppEngSlot)this.field_75151_b.get(idx);
            ItemStack itemStack = clickSlot.func_75211_c();
            ItemStack copy = itemStack.func_77946_l();
            copy.func_190920_e(1);
            ItemGasHandler gh = Utils.getItemGasHandler(copy);
            if (gh == null) {
                return ItemStack.field_190927_a;
            }
            int heldAmount = itemStack.func_190916_E();
            for (int i = 0; i < heldAmount; ++i) {
                IAEGasStack spill;
                GasStack drained;
                copy = itemStack.func_77946_l();
                copy.func_190920_e(1);
                gh = Utils.getItemGasHandler(copy);
                GasStack extract = gh.removeGas(Integer.MAX_VALUE, false);
                if (extract == null || extract.amount < 1) {
                    return ItemStack.field_190927_a;
                }
                IAEGasStack notStorable = (IAEGasStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.monitor, (IAEStack)AEGasStack.of(extract), (IActionSource)this.getActionSource(), (Actionable)Actionable.SIMULATE);
                if (notStorable != null && notStorable.getStackSize() > 0L) {
                    int toStore = (int)((long)extract.amount - notStorable.getStackSize());
                    GasStack storable = gh.removeGas(toStore, false);
                    if (storable == null || storable.amount == 0) {
                        return ItemStack.field_190927_a;
                    }
                    extract.amount = storable.amount;
                }
                extract.amount = (drained = gh.removeGas(extract, true)) == null ? 0 : drained.amount;
                IAEGasStack notInserted = (IAEGasStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.monitor, (IAEStack)AEGasStack.of(extract), (IActionSource)this.getActionSource());
                if (notInserted != null && notInserted.getStackSize() > 0L && (spill = (IAEGasStack)this.monitor.injectItems((IAEStack)notInserted, Actionable.MODULATE, this.getActionSource())) != null && spill.getStackSize() > 0L) {
                    gh.addGas(spill.getGasStack(), true);
                }
                if (notInserted != null && notInserted.getStackSize() != 0L) continue;
                if (!player.field_71071_by.func_70441_a(gh.getContainer())) {
                    player.func_71019_a(gh.getContainer(), false);
                }
                clickSlot.func_75209_a(1);
            }
            this.func_75142_b();
            return ItemStack.field_190927_a;
        }
        return super.func_82846_b(p, idx);
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        if (action != InventoryAction.FILL_ITEM && action != InventoryAction.EMPTY_ITEM) {
            super.doAction(player, action, slot, id);
            return;
        }
        ItemStack held = player.field_71071_by.func_70445_o();
        ItemStack heldCopy = held.func_77946_l();
        heldCopy.func_190920_e(1);
        ItemGasHandler gh = Utils.getItemGasHandler(heldCopy);
        if (gh == null) {
            return;
        }
        if (action == InventoryAction.FILL_ITEM && this.clientRequestedTargetGas != null) {
            IAEGasStack stack = (IAEGasStack)this.clientRequestedTargetGas.copy();
            stack.setStackSize(Integer.MAX_VALUE);
            int amountAllowed = gh.addGas(stack.getGasStack(), false);
            int heldAmount = held.func_190916_E();
            for (int i = 0; i < heldAmount; ++i) {
                ItemStack copiedGasContainer = held.func_77946_l();
                copiedGasContainer.func_190920_e(1);
                gh = Utils.getItemGasHandler(copiedGasContainer);
                IAEGasStack canPull = (IAEGasStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.monitor, (IAEStack)stack.setStackSize(amountAllowed), (IActionSource)this.getActionSource(), (Actionable)Actionable.SIMULATE);
                if (canPull == null || canPull.getStackSize() < 1L) {
                    return;
                }
                int canFill = gh.addGas(canPull.getGasStack(), false);
                if (canFill == 0) {
                    return;
                }
                IAEGasStack pulled = (IAEGasStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.monitor, (IAEStack)stack.setStackSize(canFill), (IActionSource)this.getActionSource());
                if (pulled == null || pulled.getStackSize() < 1L) {
                    MekEng.log.error("Unable to pull gas out of the ME system even though the simulation said yes ");
                    return;
                }
                int used = gh.addGas(pulled.getGasStack(), true);
                if (used != canFill) {
                    MekEng.log.error("Gas item [%s] reported a different possible amount than it actually accepted.", (Object)held.func_82833_r());
                }
                if (held.func_190916_E() == 1) {
                    player.field_71071_by.func_70437_b(gh.getContainer());
                    continue;
                }
                player.field_71071_by.func_70445_o().func_190918_g(1);
                if (player.field_71071_by.func_70441_a(gh.getContainer())) continue;
                player.func_71019_a(gh.getContainer(), false);
            }
            this.updateHeld(player);
        } else if (action == InventoryAction.EMPTY_ITEM) {
            int heldAmount = held.func_190916_E();
            for (int i = 0; i < heldAmount; ++i) {
                IAEGasStack spill;
                GasStack drained;
                ItemStack copiedGasContainer = held.func_77946_l();
                copiedGasContainer.func_190920_e(1);
                gh = Utils.getItemGasHandler(copiedGasContainer);
                GasStack extract = gh.removeGas(Integer.MAX_VALUE, false);
                if (extract == null || extract.amount < 1) {
                    return;
                }
                IAEGasStack notStorable = (IAEGasStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.monitor, (IAEStack)AEGasStack.of(extract), (IActionSource)this.getActionSource(), (Actionable)Actionable.SIMULATE);
                if (notStorable != null && notStorable.getStackSize() > 0L) {
                    int toStore = (int)((long)extract.amount - notStorable.getStackSize());
                    GasStack storable = gh.removeGas(toStore, false);
                    if (storable == null || storable.amount == 0) {
                        return;
                    }
                    extract.amount = storable.amount;
                }
                extract.amount = (drained = gh.removeGas(extract, true)) == null ? 0 : drained.amount;
                IAEGasStack notInserted = (IAEGasStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.monitor, (IAEStack)AEGasStack.of(extract), (IActionSource)this.getActionSource());
                if (notInserted != null && notInserted.getStackSize() > 0L && (spill = (IAEGasStack)this.monitor.injectItems((IAEStack)notInserted, Actionable.MODULATE, this.getActionSource())) != null && spill.getStackSize() > 0L) {
                    gh.addGas(spill.getGasStack(), true);
                }
                if (held.func_190916_E() == 1) {
                    player.field_71071_by.func_70437_b(gh.getContainer());
                    continue;
                }
                player.field_71071_by.func_70445_o().func_190918_g(1);
                if (player.field_71071_by.func_70441_a(gh.getContainer())) continue;
                player.func_71019_a(gh.getContainer(), false);
            }
            this.updateHeld(player);
        }
    }

    protected void updatePowerStatus() {
        try {
            if (this.networkNode != null) {
                this.setPowered(this.networkNode.isActive());
            } else if (this.getPowerSource() instanceof IEnergyGrid) {
                this.setPowered(((IEnergyGrid)this.getPowerSource()).isNetworkPowered());
            } else {
                this.setPowered(this.getPowerSource().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private IConfigManagerHost getGui() {
        return this.gui;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    public boolean isPowered() {
        return this.hasPower;
    }

    private void setPowered(boolean isPowered) {
        this.hasPower = isPowered;
    }

    @Override
    @Nonnull
    public Map<String, Consumer<Paras>> getActionMap() {
        return this.holder;
    }
}

