/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.container.handler;

import appeng.api.AEApi;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import appeng.helpers.WirelessTerminalGuiObject;
import com.mekeng.github.common.container.handler.MkEGuis;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class GuiFactory<T> {
    protected final Class<T> invClass;
    private final int id;

    public GuiFactory(Class<T> invClass) {
        this.invClass = invClass;
        this.id = MkEGuis.registerFactory(this);
    }

    public int getId() {
        return this.id;
    }

    protected abstract Object createServerGui(EntityPlayer var1, T var2);

    protected abstract Object createClientGui(EntityPlayer var1, T var2);

    @Nullable
    protected T getInventory(@Nullable TileEntity tile, EntityPlayer player, EnumFacing face, int slot, boolean isBauble, GuiMode mode) {
        switch (mode) {
            case TILE: {
                return this.invClass.isInstance(tile) ? (T)this.invClass.cast(tile) : null;
            }
            case PART: {
                IPart part = null;
                if (tile instanceof IPartHost) {
                    part = ((IPartHost)tile).getPart(face);
                }
                return this.invClass.isInstance(part) ? (T)this.invClass.cast(part) : null;
            }
            case ITEM: {
                ItemStack stack = player.field_71071_by.func_70448_g();
                Object guiObj = null;
                if (!stack.func_190926_b()) {
                    guiObj = GuiFactory.getItemGuiObject(stack, player, player.field_70170_p, slot, isBauble);
                }
                return this.invClass.isInstance(guiObj) ? (T)this.invClass.cast(guiObj) : null;
            }
        }
        return null;
    }

    public Object createElement(EntityPlayer player, World world, int x, int y, int z, EnumFacing face, GuiMode mode, boolean isServer) {
        Object obj;
        T inv;
        TileEntity tile = mode == GuiMode.ITEM ? null : world.func_175625_s(new BlockPos(x, y, z));
        int slot = 0;
        boolean isBauble = false;
        if (mode == GuiMode.ITEM) {
            slot = x;
            boolean bl = isBauble = y == 1;
        }
        if ((inv = this.getInventory(tile, player, face, slot, isBauble, mode)) == null) {
            return null;
        }
        Object object = obj = isServer ? this.createServerGui(player, inv) : this.createClientGui(player, inv);
        if (obj instanceof AEBaseContainer) {
            ContainerOpenContext ctx = new ContainerOpenContext(inv);
            ctx.setWorld(world);
            ctx.setX(x);
            ctx.setY(y);
            ctx.setZ(z);
            if (mode == GuiMode.PART) {
                ctx.setSide(AEPartLocation.fromFacing((EnumFacing)face));
            } else {
                ctx.setSide(AEPartLocation.INTERNAL);
            }
            ((AEBaseContainer)obj).setOpenContext(ctx);
        }
        return obj;
    }

    private static Object getItemGuiObject(ItemStack it, EntityPlayer player, World w, int slot, boolean isBauble) {
        if (!it.func_190926_b()) {
            if (it.func_77973_b() instanceof IGuiItem) {
                return ((IGuiItem)it.func_77973_b()).getGuiObject(it, w, new BlockPos(slot, isBauble ? 1 : 0, 0));
            }
            IWirelessTermHandler wh = AEApi.instance().registries().wireless().getWirelessTerminalHandler(it);
            if (wh != null) {
                return new WirelessTerminalGuiObject(wh, it, player, w, slot, isBauble ? 1 : 0, 0);
            }
        }
        return null;
    }

    public static enum GuiMode {
        TILE,
        PART,
        ITEM;

    }
}

