/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.item;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IItemList;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellUpgrades;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import com.mekeng.github.util.helpers.GasCellConfig;
import com.mekeng.github.util.helpers.GasCellInfo;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class ItemGasCell
extends AEBaseItem
implements IStorageCell<IAEGasStack>,
IItemGroup {
    private final ItemStack core;
    private final ItemStack casing;
    private final int totalBytes;
    private final double idleDrain;
    private final int perType;

    public ItemGasCell(ItemStack core, ItemStack casing, int kilobytes, double powerDrain, int typeCost) {
        this.func_77625_d(1);
        this.core = core.func_77946_l();
        this.casing = casing.func_77946_l();
        this.totalBytes = kilobytes * 1024;
        this.idleDrain = powerDrain;
        this.perType = typeCost;
    }

    public ItemGasCell(Item core, ItemStack casing, int kilobytes, double powerDrain, int typeCost) {
        this(new ItemStack(core), casing, kilobytes, powerDrain, typeCost);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        this.disassembleDrive(player.func_184586_b(hand), player);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        return this.disassembleDrive(player.func_184586_b(hand), player) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        GasCellInfo.addCellInformation(AEApi.instance().registries().cell().getCellInventory(stack, null, this.getChannel()), lines);
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        return this.casing.func_77946_l();
    }

    public boolean hasContainerItem(@Nonnull ItemStack stack) {
        return AEConfig.instance().isFeatureEnabled(AEFeature.ENABLE_DISASSEMBLY_CRAFTING);
    }

    public int getBytes(@Nonnull ItemStack itemStack) {
        return this.totalBytes;
    }

    public int getBytesPerType(@Nonnull ItemStack itemStack) {
        return this.perType;
    }

    public int getTotalTypes(@Nonnull ItemStack itemStack) {
        return 15;
    }

    public boolean isBlackListed(@Nonnull ItemStack itemStack, @Nonnull IAEGasStack gasStack) {
        return false;
    }

    public boolean storableInStorageCell() {
        return false;
    }

    public boolean isStorageCell(@Nonnull ItemStack itemStack) {
        return true;
    }

    public double getIdleDrain() {
        return this.idleDrain;
    }

    @Nonnull
    public IStorageChannel<IAEGasStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class);
    }

    public boolean isEditable(ItemStack itemStack) {
        return true;
    }

    public IItemHandler getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    public IItemHandler getConfigInventory(ItemStack is) {
        return new GasCellConfig(is);
    }

    public FuzzyMode getFuzzyMode(ItemStack itemStack) {
        return FuzzyMode.IGNORE_ALL;
    }

    public void setFuzzyMode(ItemStack itemStack, FuzzyMode fuzzyMode) {
    }

    private boolean disassembleDrive(ItemStack stack, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (Platform.isClient()) {
                return false;
            }
            InventoryPlayer playerInventory = player.field_71071_by;
            ICellInventoryHandler inv = AEApi.instance().registries().cell().getCellInventory(stack, null, this.getChannel());
            if (inv != null && playerInventory.func_70448_g() == stack) {
                InventoryAdaptor ia = InventoryAdaptor.getAdaptor((EntityPlayer)player);
                IItemList list = inv.getAvailableItems(this.getChannel().createList());
                if (list.isEmpty()) {
                    playerInventory.func_70299_a(playerInventory.field_70461_c, ItemStack.field_190927_a);
                    ItemStack extraB = ia.addItems(this.core.func_77946_l());
                    if (!extraB.func_190926_b()) {
                        player.func_71019_a(extraB, false);
                    }
                    IItemHandler upgradesInventory = this.getUpgradesInventory(stack);
                    for (int upgradeIndex = 0; upgradeIndex < upgradesInventory.getSlots(); ++upgradeIndex) {
                        ItemStack upgradeStack = upgradesInventory.getStackInSlot(upgradeIndex);
                        ItemStack leftStack = ia.addItems(upgradeStack);
                        if (leftStack.func_190926_b() || !(upgradeStack.func_77973_b() instanceof IUpgradeModule)) continue;
                        player.func_71019_a(upgradeStack, false);
                    }
                    ItemStack extraA = ia.addItems(this.casing.func_77946_l());
                    if (!extraA.func_190926_b()) {
                        player.func_71019_a(extraA, false);
                    }
                    if (player.field_71069_bz != null) {
                        player.field_71069_bz.func_75142_b();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public String getUnlocalizedGroupName(Set<ItemStack> otherItems, ItemStack is) {
        return GuiText.StorageCells.getUnlocalized();
    }
}

