/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.item;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.items.contents.CellUpgrades;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import com.mekeng.github.common.container.handler.MkEGuis;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import com.mekeng.github.util.Utils;
import com.mekeng.github.util.helpers.GasCellConfig;
import com.mekeng.github.util.helpers.GasCellInfo;
import com.mekeng.github.util.helpers.PortableGasCellViewer;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class ItemPortableGasCell
extends AEBasePoweredItem
implements IStorageCell<IAEGasStack>,
IGuiItem,
IItemGroup {
    public ItemPortableGasCell() {
        super((double)AEConfig.instance().getPortableCellBattery());
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World w, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        Utils.openItemGui(player, MkEGuis.PORTABLE_GAS_CELL);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        super.addCheckedInformation(stack, world, lines, advancedTooltips);
        ICellInventoryHandler cdi = AEApi.instance().registries().cell().getCellInventory(stack, null, AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class));
        GasCellInfo.addCellInformation(cdi, lines);
    }

    public int getBytes(@Nonnull ItemStack cellItem) {
        return 512;
    }

    public int getBytesPerType(@Nonnull ItemStack cellItem) {
        return 8;
    }

    public int getTotalTypes(@Nonnull ItemStack cellItem) {
        return 5;
    }

    public boolean isBlackListed(@Nonnull ItemStack cellItem, @Nonnull IAEGasStack requestedAddition) {
        return false;
    }

    public boolean storableInStorageCell() {
        return false;
    }

    public boolean isStorageCell(@Nonnull ItemStack i) {
        return true;
    }

    public double getIdleDrain() {
        return 0.5;
    }

    @Nonnull
    public IStorageChannel<IAEGasStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class);
    }

    public String getUnlocalizedGroupName(Set<ItemStack> others, ItemStack is) {
        return GuiText.StorageCells.getUnlocalized();
    }

    public boolean isEditable(ItemStack is) {
        return true;
    }

    public IItemHandler getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    public IItemHandler getConfigInventory(ItemStack is) {
        return new GasCellConfig(is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        return FuzzyMode.IGNORE_ALL;
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
    }

    public IGuiItemObject getGuiObject(ItemStack is, World w, BlockPos pos) {
        return new PortableGasCellViewer(is, pos.func_177958_n());
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }
}

