/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.me.client;

import appeng.api.AEApi;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.config.YesNo;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.core.AEConfig;
import appeng.util.Platform;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import com.mekeng.github.util.Utils;
import com.mekeng.github.util.helpers.GasSorters;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class GasRepo {
    private final IItemList<IAEGasStack> list = ((IGasStorageChannel)AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)).createList();
    private final ArrayList<IAEGasStack> view = new ArrayList();
    private final IScrollSource src;
    private final ISortSource sortSrc;
    private int rowSize = 9;
    private String searchString = "";
    private boolean hasPower;

    public GasRepo(IScrollSource src, ISortSource sortSrc) {
        this.src = src;
        this.sortSrc = sortSrc;
    }

    public void updateView() {
        Pattern m;
        this.view.clear();
        this.view.ensureCapacity(this.list.size());
        String innerSearch = this.searchString;
        boolean searchMod = false;
        if (innerSearch.startsWith("@")) {
            searchMod = true;
            innerSearch = innerSearch.substring(1);
        }
        try {
            m = Pattern.compile(innerSearch.toLowerCase(), 2);
        }
        catch (Exception ignore1) {
            try {
                m = Pattern.compile(Pattern.quote(innerSearch.toLowerCase()), 2);
            }
            catch (Exception ignore2) {
                return;
            }
        }
        Enum viewMode = this.sortSrc.getSortDisplay();
        boolean needsZeroCopy = viewMode == ViewItems.CRAFTABLE;
        boolean terminalSearchToolTips = AEConfig.instance().getConfigManager().getSetting(Settings.SEARCH_TOOLTIPS) != YesNo.NO;
        for (IAEGasStack gs : this.list) {
            if (viewMode == ViewItems.CRAFTABLE && !gs.isCraftable() || viewMode == ViewItems.STORED && gs.getStackSize() == 0L) continue;
            String dspName = searchMod ? Utils.getGasModID(gs) : Utils.getGasDisplayName(gs);
            boolean foundMatchingGasStack = false;
            boolean notDone = true;
            if (m.matcher(dspName.toLowerCase()).find()) {
                notDone = false;
                foundMatchingGasStack = true;
            }
            if (terminalSearchToolTips && notDone && !searchMod) {
                List tooltip = Platform.getTooltip((Object)gs);
                for (String line : tooltip) {
                    if (!m.matcher(line).find()) continue;
                    foundMatchingGasStack = true;
                    break;
                }
            }
            if (!foundMatchingGasStack) continue;
            if (needsZeroCopy) {
                gs = (IAEGasStack)gs.copy();
                gs.setStackSize(0L);
            }
            this.view.add(gs);
        }
        Enum sortBy = this.sortSrc.getSortBy();
        Enum sortDir = this.sortSrc.getSortDir();
        GasSorters.setDirection((SortDir)sortDir);
        if (sortBy == SortOrder.MOD) {
            this.view.sort(GasSorters.CONFIG_BASED_SORT_BY_MOD);
        } else if (sortBy == SortOrder.AMOUNT) {
            this.view.sort(GasSorters.CONFIG_BASED_SORT_BY_SIZE);
        } else {
            this.view.sort(GasSorters.CONFIG_BASED_SORT_BY_NAME);
        }
    }

    public void postUpdate(IAEGasStack is) {
        IAEGasStack st = (IAEGasStack)this.list.findPrecise((IAEStack)is);
        if (st != null) {
            st.reset();
            st.add(is);
        } else {
            this.list.add((IAEStack)is);
        }
    }

    public IAEGasStack getReferenceGas(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.view.size()) {
            return null;
        }
        return this.view.get(idx);
    }

    public int size() {
        return this.view.size();
    }

    public void clear() {
        this.list.resetStatus();
    }

    public boolean hasPower() {
        return this.hasPower;
    }

    public void setPower(boolean hasPower) {
        this.hasPower = hasPower;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(@Nonnull String searchString) {
        this.searchString = searchString;
    }
}

