/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.me.data.impl;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import appeng.util.item.AEStack;
import com.google.common.primitives.Ints;
import com.mekeng.github.common.ItemAndBlocks;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class AEGasStack
extends AEStack<IAEGasStack>
implements IAEGasStack,
Comparable<AEGasStack> {
    private final Gas gas;

    private AEGasStack(@Nonnull Gas gas, long amt) {
        this.gas = gas;
        this.setStackSize(amt);
        this.setCraftable(false);
        this.setCountRequestable(0L);
    }

    private AEGasStack(GasStack gasStack) {
        this(gasStack.getGas(), gasStack.amount);
    }

    private AEGasStack(AEGasStack gasStack) {
        this.gas = gasStack.gas;
        this.setStackSize(gasStack.getStackSize());
        this.setCraftable(gasStack.isCraftable());
        this.setCountRequestable(gasStack.getCountRequestable());
    }

    @Nullable
    public static AEGasStack of(GasStack input) {
        return input == null || input.getGas() == null ? null : new AEGasStack(input);
    }

    @Nullable
    public static IAEGasStack of(NBTTagCompound data) {
        GasStack gasStack = GasStack.readFromNBT((NBTTagCompound)data);
        if (gasStack == null) {
            return null;
        }
        return (IAEGasStack)((IAEGasStack)((IAEGasStack)AEGasStack.of(gasStack).setStackSize(data.func_74763_f("Cnt"))).setCountRequestable(data.func_74763_f("Req"))).setCraftable(data.func_74767_n("Craft"));
    }

    @Nullable
    public static IAEGasStack of(ByteBuf buffer) {
        Gas gas = GasRegistry.getGas((int)buffer.readShort());
        long amt = buffer.readLong();
        if (gas != null) {
            return (IAEGasStack)((IAEGasStack)new AEGasStack(gas, amt).setCountRequestable(buffer.readLong())).setCraftable(buffer.readBoolean());
        }
        return null;
    }

    @Override
    public GasStack getGasStack() {
        return new GasStack(this.gas, Ints.saturatedCast((long)this.getStackSize()));
    }

    @Override
    public Gas getGas() {
        return this.gas;
    }

    public void add(IAEGasStack option) {
        if (option != null) {
            this.incStackSize(option.getStackSize());
            ((IAEGasStack)this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable())).setCraftable(this.isCraftable() || option.isCraftable());
        }
    }

    protected boolean hasTagCompound() {
        return false;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        GasStack stack = this.getGasStack();
        stack.write(nbt);
        nbt.func_74772_a("Cnt", this.getStackSize());
        nbt.func_74772_a("Req", this.getCountRequestable());
        nbt.func_74757_a("Craft", this.isCraftable());
    }

    public boolean fuzzyComparison(IAEGasStack gasStack, FuzzyMode fuzzyMode) {
        return this.gas == gasStack.getGas();
    }

    public void writeToPacket(ByteBuf buffer) {
        buffer.writeShort(this.gas.getID());
        buffer.writeLong(this.getStackSize());
        buffer.writeLong(this.getCountRequestable());
        buffer.writeBoolean(this.isCraftable());
    }

    public IAEGasStack copy() {
        return new AEGasStack(this);
    }

    public boolean isItem() {
        return false;
    }

    public boolean isFluid() {
        return false;
    }

    public IStorageChannel<IAEGasStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class);
    }

    public ItemStack asItemStackRepresentation() {
        ItemStack stack = new ItemStack((Item)ItemAndBlocks.DUMMY_GAS);
        ItemAndBlocks.DUMMY_GAS.setGasStack(stack, this.getGasStack());
        return stack;
    }

    @Override
    public int compareTo(AEGasStack o) {
        if (o.gas != this.gas) {
            return o.gas.getName().compareTo(this.gas.getName());
        }
        return 0;
    }

    public int hashCode() {
        return this.gas.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof IAEGasStack) {
            return ((IAEGasStack)other).getGas() == this.gas;
        }
        if (other instanceof GasStack) {
            return ((GasStack)other).getGas() == this.gas;
        }
        return false;
    }

    public String toString() {
        return this.getStackSize() + "x" + this.gas.getName();
    }
}

