/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.me.duality.impl;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.tiles.ICraftingMachine;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.core.settings.TickRates;
import appeng.helpers.ICustomNameObject;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.MEMonitorPassThrough;
import appeng.me.storage.NullInventory;
import appeng.parts.automation.StackUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.duality.IGasInterfaceHost;
import com.mekeng.github.common.me.inventory.IConfigurableGasInventory;
import com.mekeng.github.common.me.inventory.IGasInventory;
import com.mekeng.github.common.me.inventory.IGasInventoryHost;
import com.mekeng.github.common.me.inventory.impl.GasInvHandler;
import com.mekeng.github.common.me.inventory.impl.GasInventory;
import com.mekeng.github.common.me.inventory.impl.GasNetworkAdapter;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import com.mekeng.github.common.me.storage.impl.MEMonitorIGasHandler;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.metatileentity.MetaTileEntity;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;

public class DualityGasInterface
implements IGridTickable,
IStorageMonitorable,
IAEAppEngInventory,
IUpgradeableHost,
IConfigManagerHost,
IConfigurableGasInventory,
IGasInventoryHost {
    public static final int NUMBER_OF_TANKS = 9;
    public static final int TANK_CAPACITY = 4000;
    private static final Collection<Block> BAD_BLOCKS = new HashSet<Block>(100);
    private final ConfigManager cm = new ConfigManager((IConfigManagerHost)this);
    private final AENetworkProxy gridProxy;
    private final IGasInterfaceHost iHost;
    private final IActionSource interfaceRequestSource;
    private final UpgradeInventory upgrades;
    private boolean hasConfig = false;
    private final IStorageMonitorableAccessor accessor = this::getMonitorable;
    private final GasInventory tanks = new GasInventory(9, 4000, this);
    private final GasInvHandler handler;
    private final GasInventory config = new GasInventory(9, this);
    private final IAEGasStack[] requireWork;
    private int isWorking = -1;
    private int priority;
    private final MEMonitorPassThrough<IAEItemStack> items = new MEMonitorPassThrough((IMEInventory)new NullInventory(), AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
    private final MEMonitorPassThrough<IAEGasStack> gases = new MEMonitorPassThrough((IMEInventory)new NullInventory(), AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class));
    private boolean resetConfigCache = true;
    private IMEMonitor<IAEGasStack> configCachedHandler;

    public DualityGasInterface(AENetworkProxy networkProxy, IGasInterfaceHost ih) {
        this.gridProxy = networkProxy;
        this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.upgrades = new StackUpgradeInventory(this.gridProxy.getMachineRepresentation(), (IAEAppEngInventory)this, 2);
        this.cm.registerSetting(Settings.INTERFACE_TERMINAL, (Enum)YesNo.YES);
        this.iHost = ih;
        MachineSource mySource = new MachineSource((IActionHost)this.iHost);
        this.interfaceRequestSource = new InterfaceRequestSource(this.iHost);
        this.items.setChangeSource((IActionSource)mySource);
        this.gases.setChangeSource((IActionSource)mySource);
        this.requireWork = new IAEGasStack[9];
        for (int i = 0; i < 9; ++i) {
            this.requireWork[i] = null;
        }
        this.handler = DualityGasInterface.isMekCEuInstalled() ? new GasInvHandler(this.tanks) : new GasNetworkAdapter(this::getStorageGrid, (IActionSource)mySource, this.tanks);
    }

    private static boolean isMekCEuInstalled() {
        try {
            Class.forName("mekanism.common.concurrent.TaskExecutor");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Nullable
    private IStorageGrid getStorageGrid() {
        try {
            return this.gridProxy.getStorage();
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        if (channel == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            if (this.hasConfig()) {
                return null;
            }
            return this.items;
        }
        if (channel == AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)) {
            if (this.hasConfig()) {
                if (this.resetConfigCache) {
                    this.resetConfigCache = false;
                    this.configCachedHandler = new InterfaceInventory(this);
                }
                return this.configCachedHandler;
            }
            return this.gases;
        }
        return null;
    }

    public IStorageMonitorable getMonitorable(IActionSource src) {
        if (Platform.canAccess((AENetworkProxy)this.gridProxy, (IActionSource)src)) {
            return this;
        }
        return null;
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(TickRates.Interface.getMin(), TickRates.Interface.getMax(), !this.hasWorkToDo(), true);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        if (!this.gridProxy.isActive()) {
            return TickRateModulation.SLEEP;
        }
        boolean couldDoWork = this.updateStorage();
        return this.hasWorkToDo() ? (couldDoWork ? TickRateModulation.URGENT : TickRateModulation.SLOWER) : TickRateModulation.SLEEP;
    }

    public void notifyNeighbors() {
        TileEntity te;
        if (this.gridProxy.isActive()) {
            try {
                this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if ((te = this.iHost.getTileEntity()) != null && te.func_145831_w() != null) {
            Platform.notifyBlocksOfNeighbors((World)te.func_145831_w(), (BlockPos)te.func_174877_v());
        }
    }

    public void gridChanged() {
        try {
            this.items.setInternal((IMEInventory)this.gridProxy.getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)));
            this.gases.setInternal((IMEInventory)this.gridProxy.getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)));
        }
        catch (GridAccessException gae) {
            this.items.setInternal((IMEInventory)new NullInventory());
            this.gases.setInternal((IMEInventory)new NullInventory());
        }
        this.notifyNeighbors();
    }

    public AECableType getCableConnectionType() {
        return AECableType.SMART;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.iHost.getTileEntity());
    }

    private boolean sameGrid(IGrid grid) throws GridAccessException {
        return grid == this.gridProxy.getGrid();
    }

    public String getTermName() {
        TileEntity hostTile = this.iHost.getTileEntity();
        World hostWorld = hostTile.func_145831_w();
        if (((ICustomNameObject)this.iHost).hasCustomInventoryName()) {
            return ((ICustomNameObject)this.iHost).getCustomInventoryName();
        }
        EnumSet<EnumFacing> possibleDirections = this.iHost.getTargets();
        for (EnumFacing direction : possibleDirections) {
            MetaTileEntity metaTileEntity;
            BlockPos targ = hostTile.func_174877_v().func_177972_a(direction);
            TileEntity directedTile = hostWorld.func_175625_s(targ);
            if (directedTile == null) continue;
            if (directedTile instanceof IGasInterfaceHost) {
                try {
                    if (((IGasInterfaceHost)directedTile).getDualityGasInterface().sameGrid(this.gridProxy.getGrid())) {
                    }
                }
                catch (GridAccessException e) {}
                continue;
            }
            InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor((TileEntity)directedTile, (EnumFacing)direction.func_176734_d());
            if (!(directedTile instanceof ICraftingMachine) && adaptor == null || adaptor != null && !adaptor.hasSlots()) continue;
            IBlockState directedBlockState = hostWorld.func_180495_p(targ);
            Block directedBlock = directedBlockState.func_177230_c();
            ItemStack what = new ItemStack(directedBlock, 1, directedBlock.func_176201_c(directedBlockState));
            if (Platform.GTLoaded && directedBlock instanceof BlockMachine && (metaTileEntity = Platform.getMetaTileEntity((IBlockAccess)directedTile.func_145831_w(), (BlockPos)directedTile.func_174877_v())) != null) {
                return metaTileEntity.getMetaFullName();
            }
            try {
                ItemStack g;
                Vec3d from = new Vec3d((double)hostTile.func_174877_v().func_177958_n() + 0.5, (double)hostTile.func_174877_v().func_177956_o() + 0.5, (double)hostTile.func_174877_v().func_177952_p() + 0.5);
                from = from.func_72441_c((double)direction.func_82601_c() * 0.501, (double)direction.func_96559_d() * 0.501, (double)direction.func_82599_e() * 0.501);
                Vec3d to = from.func_72441_c((double)direction.func_82601_c(), (double)direction.func_96559_d(), (double)direction.func_82599_e());
                RayTraceResult mop = hostWorld.func_72901_a(from, to, true);
                if (mop != null && !BAD_BLOCKS.contains(directedBlock) && mop.func_178782_a().equals((Object)directedTile.func_174877_v()) && !(g = directedBlock.getPickBlock(directedBlockState, mop, hostWorld, directedTile.func_174877_v(), null)).func_190926_b()) {
                    what = g;
                }
            }
            catch (Throwable t) {
                BAD_BLOCKS.add(directedBlock);
            }
            if (what.func_77973_b() != Items.field_190931_a) {
                return what.func_77973_b().func_77653_i(what);
            }
            Item item = Item.func_150898_a((Block)directedBlock);
            if (item != Items.field_190931_a) continue;
            return directedBlock.func_149739_a();
        }
        return "Nothing";
    }

    public long getSortValue() {
        TileEntity te = this.iHost.getTileEntity();
        return (long)te.func_174877_v().func_177952_p() << 24 ^ (long)te.func_174877_v().func_177958_n() << 8 ^ (long)te.func_174877_v().func_177956_o();
    }

    public boolean hasCapability(Capability<?> capabilityClass, EnumFacing facing) {
        return capabilityClass == Capabilities.GAS_HANDLER_CAPABILITY || capabilityClass == appeng.capabilities.Capabilities.STORAGE_MONITORABLE_ACCESSOR;
    }

    public <T> T getCapability(Capability<T> capabilityClass, EnumFacing facing) {
        if (capabilityClass == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        if (capabilityClass == appeng.capabilities.Capabilities.STORAGE_MONITORABLE_ACCESSOR) {
            return (T)this.accessor;
        }
        return null;
    }

    public GasInvHandler getTankHandler() {
        return this.handler;
    }

    private boolean hasConfig() {
        return this.hasConfig;
    }

    private void readConfig() {
        this.hasConfig = false;
        for (int i = 0; i < this.config.size(); ++i) {
            if (this.config.getGasStack(i) == null) continue;
            this.hasConfig = true;
            break;
        }
        boolean had = this.hasWorkToDo();
        for (int x = 0; x < 9; ++x) {
            this.updatePlan(x);
        }
        boolean has = this.hasWorkToDo();
        if (had != has) {
            try {
                if (has) {
                    this.gridProxy.getTick().alertDevice(this.gridProxy.getNode());
                } else {
                    this.gridProxy.getTick().sleepDevice(this.gridProxy.getNode());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        this.notifyNeighbors();
    }

    private boolean updateStorage() {
        boolean didSomething = false;
        for (int x = 0; x < 9; ++x) {
            if (this.requireWork[x] == null) continue;
            didSomething = this.usePlan(x) || didSomething;
        }
        return didSomething;
    }

    private boolean hasWorkToDo() {
        for (IAEGasStack requiredWork : this.requireWork) {
            if (requiredWork == null) continue;
            return true;
        }
        return false;
    }

    private void updatePlan(int slot) {
        AEGasStack req = AEGasStack.of(this.config.getGasStack(slot));
        AEGasStack stored = AEGasStack.of(this.tanks.getGasStack(slot));
        if (req == null && stored != null && stored.getStackSize() > 0L) {
            IAEGasStack work = (IAEGasStack)stored.copy();
            this.requireWork[slot] = (IAEGasStack)work.setStackSize(-work.getStackSize());
            return;
        }
        if (req != null) {
            int tankSize = (int)(Math.pow(4.0, this.getInstalledUpgrades(Upgrades.CAPACITY) + 1) * 1000.0);
            if (stored == null || stored.getStackSize() == 0L) {
                this.requireWork[slot] = (IAEGasStack)req.copy();
                this.requireWork[slot].setStackSize(tankSize);
                return;
            }
            if (((Object)req).equals(stored)) {
                if (stored.getStackSize() != (long)tankSize) {
                    this.requireWork[slot] = (IAEGasStack)req.copy();
                    this.requireWork[slot].setStackSize((long)tankSize - stored.getStackSize());
                    return;
                }
            } else {
                IAEGasStack work = (IAEGasStack)stored.copy();
                this.requireWork[slot] = (IAEGasStack)work.setStackSize(-work.getStackSize());
                return;
            }
        }
        this.requireWork[slot] = null;
    }

    private boolean usePlan(int slot) {
        IAEGasStack work = this.requireWork[slot];
        this.isWorking = slot;
        boolean changed = false;
        try {
            IMEMonitor dest = this.gridProxy.getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class));
            IEnergyGrid src = this.gridProxy.getEnergy();
            if (work.getStackSize() > 0L) {
                IAEGasStack acquired;
                if ((long)this.tanks.addGas(slot, work.getGasStack(), true) != work.getStackSize()) {
                    changed = true;
                } else if (this.gridProxy.getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)).getStorageList().findPrecise((IAEStack)work) != null && (acquired = (IAEGasStack)Platform.poweredExtraction((IEnergySource)src, (IMEInventory)dest, (IAEStack)work, (IActionSource)this.interfaceRequestSource)) != null) {
                    changed = true;
                    int filled = this.tanks.addGas(slot, acquired.getGasStack(), false);
                    if ((long)filled != acquired.getStackSize()) {
                        throw new IllegalStateException("bad attempt at managing tanks. ( fill )");
                    }
                }
            } else if (work.getStackSize() < 0L) {
                IAEGasStack toStore = (IAEGasStack)work.copy();
                toStore.setStackSize(-toStore.getStackSize());
                GasStack canExtract = this.tanks.removeGas(slot, toStore.getGasStack(), true);
                if (canExtract == null || (long)canExtract.amount != toStore.getStackSize()) {
                    changed = true;
                } else {
                    IAEGasStack notStored = (IAEGasStack)Platform.poweredInsert((IEnergySource)src, (IMEInventory)dest, (IAEStack)toStore, (IActionSource)this.interfaceRequestSource);
                    toStore.setStackSize(toStore.getStackSize() - (notStored == null ? 0L : notStored.getStackSize()));
                    if (toStore.getStackSize() > 0L) {
                        changed = true;
                        GasStack removed = this.tanks.removeGas(slot, toStore.getGasStack(), false);
                        if (removed == null || toStore.getStackSize() != (long)removed.amount) {
                            throw new IllegalStateException("bad attempt at managing tanks. ( drain )");
                        }
                    }
                }
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (changed) {
            this.updatePlan(slot);
        }
        this.isWorking = -1;
        return changed;
    }

    @Override
    public void onGasInventoryChanged(IGasInventory inventory, int slot) {
        if (this.isWorking == slot) {
            return;
        }
        if (inventory == this.config) {
            boolean cfg = this.hasConfig();
            this.readConfig();
            if (cfg != this.hasConfig) {
                this.resetConfigCache = true;
                this.notifyNeighbors();
            }
        } else if (inventory == this.tanks) {
            this.saveChanges();
            boolean had = this.hasWorkToDo();
            this.updatePlan(slot);
            boolean now = this.hasWorkToDo();
            if (had != now) {
                try {
                    if (now) {
                        this.gridProxy.getTick().alertDevice(this.gridProxy.getNode());
                    } else {
                        this.gridProxy.getTick().sleepDevice(this.gridProxy.getNode());
                    }
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74768_a("priority", this.priority);
        data.func_74782_a("storage", (NBTBase)this.tanks.save());
        data.func_74782_a("config", (NBTBase)this.config.save());
        this.upgrades.writeToNBT(data, "upgrades");
    }

    public void readFromNBT(NBTTagCompound data) {
        this.config.load(data.func_74775_l("config"));
        this.tanks.load(data.func_74775_l("storage"));
        this.priority = data.func_74762_e("priority");
        this.upgrades.readFromNBT(data, "upgrades");
        this.tanks.setCap((int)(Math.pow(4.0, this.getInstalledUpgrades(Upgrades.CAPACITY) + 1) * 1000.0));
        this.readConfig();
    }

    public IGasInventory getConfig() {
        return this.config;
    }

    public IGasInventory getTanks() {
        return this.tanks;
    }

    public void saveChanges() {
        this.iHost.saveChanges();
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.upgrades) {
            this.tanks.setCap((int)(Math.pow(4.0, this.getInstalledUpgrades(Upgrades.CAPACITY) + 1) * 1000.0));
            try {
                this.gridProxy.getTick().alertDevice(this.gridProxy.getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            for (int x = 0; x < 9; ++x) {
                this.updatePlan(x);
            }
        }
    }

    public IConfigManager getConfigManager() {
        return this.cm;
    }

    public IItemHandler getInventoryByName(String name) {
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    @Override
    public IGasInventory getGasInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        return null;
    }

    public int getInstalledUpgrades(Upgrades u) {
        if (this.upgrades == null) {
            return 0;
        }
        return this.upgrades.getInstalledUpgrades(u);
    }

    public void addDrops(List<ItemStack> drops) {
        for (ItemStack is : this.upgrades) {
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    public TileEntity getTile() {
        return (TileEntity)(this.iHost instanceof TileEntity ? this.iHost : null);
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    private class InterfaceInventory
    extends MEMonitorIGasHandler {
        InterfaceInventory(DualityGasInterface tileInterface) {
            super(new GasInvHandler(tileInterface.tanks), null);
        }

        @Override
        public IAEGasStack injectItems(IAEGasStack input, Actionable type, IActionSource src) {
            Optional context = src.context(InterfaceRequestContext.class);
            boolean isInterface = context.isPresent();
            if (isInterface) {
                return input;
            }
            return super.injectItems(input, type, src);
        }

        @Override
        public IAEGasStack extractItems(IAEGasStack request, Actionable type, IActionSource src) {
            Optional context = src.context(InterfaceRequestContext.class);
            boolean hasLowerOrEqualPriority = context.map(c -> c.compareTo(DualityGasInterface.this.priority) <= 0).orElse(false);
            if (hasLowerOrEqualPriority) {
                return null;
            }
            return super.extractItems(request, type, src);
        }
    }

    private class InterfaceRequestContext
    implements Comparable<Integer> {
        private InterfaceRequestContext() {
        }

        @Override
        public int compareTo(@Nonnull Integer o) {
            return Integer.compare(DualityGasInterface.this.priority, o);
        }
    }

    private class InterfaceRequestSource
    extends MachineSource {
        private final InterfaceRequestContext context;

        InterfaceRequestSource(IActionHost v) {
            super(v);
            this.context = new InterfaceRequestContext();
        }

        @Nonnull
        public <T> Optional<T> context(Class<T> key) {
            if (key == InterfaceRequestContext.class) {
                return Optional.of(this.context);
            }
            return super.context(key);
        }
    }
}

