/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.me.inventory.impl;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.GridAccessException;
import appeng.me.helpers.IGridProxyable;
import appeng.me.storage.ITickingMonitor;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import com.mekeng.github.common.part.PartGasStorageBus;
import com.mekeng.github.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import net.minecraft.util.EnumFacing;

public class GasHandlerAdapter
implements IMEInventory<IAEGasStack>,
IBaseMonitor<IAEGasStack>,
ITickingMonitor {
    private final Map<IMEMonitorHandlerReceiver<IAEGasStack>, Object> listeners = new HashMap<IMEMonitorHandlerReceiver<IAEGasStack>, Object>();
    private IActionSource source;
    private final IGasHandler gasHandler;
    private final IGridProxyable proxyable;
    private final InventoryCache cache;
    private StorageFilter mode;
    private AccessRestriction access;
    private final EnumFacing face;

    public GasHandlerAdapter(IGasHandler gasHandler, IGridProxyable proxy, EnumFacing face) {
        this.gasHandler = gasHandler;
        this.proxyable = proxy;
        this.face = face;
        if (this.proxyable instanceof PartGasStorageBus) {
            PartGasStorageBus partGasStorageBus = (PartGasStorageBus)this.proxyable;
            this.mode = (StorageFilter)partGasStorageBus.getConfigManager().getSetting(Settings.STORAGE_FILTER);
            this.access = (AccessRestriction)partGasStorageBus.getConfigManager().getSetting(Settings.ACCESS);
        }
        this.cache = new InventoryCache(this.gasHandler, this.mode, this.face);
        this.cache.update();
    }

    public IAEGasStack injectItems(IAEGasStack input, Actionable type, IActionSource src) {
        if (input == null || input.getStackSize() == 0L) {
            return null;
        }
        GasStack gasStack = input.getGasStack();
        if (!this.gasHandler.canReceiveGas(this.face, gasStack.getGas())) {
            return input;
        }
        int wasFillled = this.gasHandler.receiveGas(this.face, gasStack, type != Actionable.SIMULATE);
        int remaining = gasStack.amount - wasFillled;
        if (gasStack.amount == remaining) {
            return input;
        }
        if (type == Actionable.MODULATE) {
            IAEGasStack added = (IAEGasStack)((IAEGasStack)input.copy()).setStackSize(input.getStackSize() - (long)remaining);
            this.cache.currentlyCached.add((IAEStack)added);
            this.postDifference(Collections.singletonList(added));
            try {
                this.proxyable.getProxy().getTick().alertDevice(this.proxyable.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        gasStack.amount = remaining;
        return AEGasStack.of(gasStack);
    }

    public IAEGasStack extractItems(IAEGasStack request, Actionable mode, IActionSource src) {
        if (request == null || request.getStackSize() == 0L) {
            return null;
        }
        GasStack requestedGasStack = request.getGasStack();
        if (!this.gasHandler.canDrawGas(this.face, requestedGasStack.getGas())) {
            return null;
        }
        boolean doDrain = mode == Actionable.MODULATE;
        GasStack gathered = Utils.drawGas(this.gasHandler, requestedGasStack, this.face, requestedGasStack.amount, doDrain);
        if (gathered == null) {
            return null;
        }
        AEGasStack gatheredAEGasStack = AEGasStack.of(gathered);
        if (mode == Actionable.MODULATE) {
            IAEGasStack cachedStack = (IAEGasStack)this.cache.currentlyCached.findPrecise((IAEStack)request);
            if (cachedStack != null) {
                cachedStack.decStackSize(gatheredAEGasStack.getStackSize());
                this.postDifference(Collections.singletonList(((IAEGasStack)gatheredAEGasStack.copy()).setStackSize(-gatheredAEGasStack.getStackSize())));
            }
            try {
                this.proxyable.getProxy().getTick().alertDevice(this.proxyable.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return gatheredAEGasStack;
    }

    public TickRateModulation onTick() {
        List<IAEGasStack> changes = this.cache.update();
        if (!changes.isEmpty() && this.access.hasPermission(AccessRestriction.READ)) {
            this.postDifference(changes);
            return TickRateModulation.URGENT;
        }
        return TickRateModulation.SLOWER;
    }

    public IItemList<IAEGasStack> getAvailableItems(IItemList<IAEGasStack> out) {
        return this.cache.getAvailableItems(out);
    }

    public IStorageChannel<IAEGasStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class);
    }

    public void setActionSource(IActionSource source) {
        this.source = source;
    }

    public void addListener(IMEMonitorHandlerReceiver<IAEGasStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    public void removeListener(IMEMonitorHandlerReceiver<IAEGasStack> l) {
        this.listeners.remove(l);
    }

    private void postDifference(Iterable<IAEGasStack> a) {
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEGasStack>, Object>> i = this.listeners.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<IMEMonitorHandlerReceiver<IAEGasStack>, Object> l = i.next();
            IMEMonitorHandlerReceiver<IAEGasStack> key = l.getKey();
            if (key.isValid(l.getValue())) {
                key.postChange((IBaseMonitor)this, a, this.source);
                continue;
            }
            i.remove();
        }
    }

    private static class InventoryCache {
        private final IGasHandler gasHandler;
        private final StorageFilter mode;
        private final EnumFacing face;
        IItemList<IAEGasStack> currentlyCached = ((IGasStorageChannel)AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)).createList();

        public InventoryCache(IGasHandler gasHandler, StorageFilter mode, EnumFacing face) {
            this.mode = mode;
            this.gasHandler = gasHandler;
            this.face = face;
        }

        public List<IAEGasStack> update() {
            ArrayList<IAEGasStack> changes = new ArrayList<IAEGasStack>();
            GasTankInfo[] tankProperties = this.gasHandler.getTankInfo();
            IItemList currentlyOnStorage = ((IGasStorageChannel)AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)).createList();
            for (GasTankInfo tankProperty : tankProperties) {
                if (this.mode == StorageFilter.EXTRACTABLE_ONLY && this.gasHandler.drawGas(this.face, 1, false) == null) continue;
                currentlyOnStorage.add((IAEStack)AEGasStack.of(tankProperty.getGas()));
            }
            for (IAEGasStack is : this.currentlyCached) {
                is.setStackSize(-is.getStackSize());
            }
            for (IAEGasStack is : currentlyOnStorage) {
                this.currentlyCached.add((IAEStack)is);
            }
            for (IAEGasStack is : this.currentlyCached) {
                if (is.getStackSize() == 0L) continue;
                changes.add(is);
            }
            this.currentlyCached = currentlyOnStorage;
            return changes;
        }

        public IItemList<IAEGasStack> getAvailableItems(IItemList<IAEGasStack> out) {
            this.currentlyCached.iterator().forEachRemaining(arg_0 -> out.add(arg_0));
            return out;
        }
    }
}

