/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.me.inventory.impl;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEStack;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.inventory.IGasInventory;
import com.mekeng.github.common.me.inventory.impl.GasInvHandler;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import java.util.function.Supplier;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import net.minecraft.util.EnumFacing;

public class GasNetworkAdapter
extends GasInvHandler {
    private final Supplier<IStorageGrid> supplier;
    private final IActionSource source;

    public GasNetworkAdapter(Supplier<IStorageGrid> networkSupplier, IActionSource source, IGasInventory inv) {
        super(inv);
        this.supplier = networkSupplier;
        this.source = source;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        IStorageGrid storage = this.supplier.get();
        if (storage != null) {
            int originAmt = stack.amount;
            IMEMonitor dest = storage.getInventory(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class));
            IAEGasStack overflow = (IAEGasStack)dest.injectItems((IAEStack)AEGasStack.of(stack), doTransfer ? Actionable.MODULATE : Actionable.SIMULATE, this.source);
            if (overflow != null && overflow.getStackSize() == (long)originAmt) {
                return super.receiveGas(side, stack, doTransfer);
            }
            if (overflow != null) {
                return (int)((long)originAmt - overflow.getStackSize());
            }
            return originAmt;
        }
        return super.receiveGas(side, stack, doTransfer);
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        IMEMonitor dest;
        IStorageGrid storage = this.supplier.get();
        if (storage != null && (dest = storage.getInventory(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class))).injectItems((IAEStack)AEGasStack.of(new GasStack(type, 1)), Actionable.SIMULATE, this.source) == null) {
            return true;
        }
        return super.canReceiveGas(side, type);
    }
}

