/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.me.storage.impl;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IItemList;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.storage.impl.MeaningfulGasIterator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;

public class GasList
implements IItemList<IAEGasStack> {
    private final Map<IAEGasStack, IAEGasStack> records = new Object2ObjectOpenHashMap();

    protected GasList() {
    }

    public static GasList create() {
        return new GasList();
    }

    public void addStorage(IAEGasStack option) {
        if (option != null) {
            IAEGasStack st = this.getGasRecord(option);
            if (st != null) {
                st.incStackSize(option.getStackSize());
            } else {
                IAEGasStack opt = (IAEGasStack)option.copy();
                this.putGasRecord(opt);
            }
        }
    }

    public void addCrafting(IAEGasStack option) {
        if (option != null) {
            IAEGasStack st = this.getGasRecord(option);
            if (st != null) {
                st.setCraftable(true);
            } else {
                IAEGasStack opt = (IAEGasStack)option.copy();
                opt.setStackSize(0L);
                opt.setCraftable(true);
                this.putGasRecord(opt);
            }
        }
    }

    public void addRequestable(IAEGasStack option) {
        if (option != null) {
            IAEGasStack st = this.getGasRecord(option);
            if (st != null) {
                st.setCountRequestable(st.getCountRequestable() + option.getCountRequestable());
            } else {
                IAEGasStack opt = (IAEGasStack)option.copy();
                opt.setStackSize(0L);
                opt.setCraftable(false);
                opt.setCountRequestable(option.getCountRequestable());
                this.putGasRecord(opt);
            }
        }
    }

    public IAEGasStack getFirstItem() {
        Iterator<IAEGasStack> iterator = this.iterator();
        if (iterator.hasNext()) {
            IAEGasStack gas = iterator.next();
            return gas;
        }
        return null;
    }

    public int size() {
        return this.records.values().size();
    }

    @Nonnull
    public Iterator<IAEGasStack> iterator() {
        return new MeaningfulGasIterator<IAEGasStack>(this.records.values().iterator());
    }

    public void resetStatus() {
        Iterator<IAEGasStack> iterator = this.iterator();
        while (iterator.hasNext()) {
            IAEGasStack gas = iterator.next();
            gas.reset();
        }
    }

    public void add(IAEGasStack option) {
        if (option != null) {
            IAEGasStack st = this.getGasRecord(option);
            if (st != null) {
                st.add(option);
            } else {
                IAEGasStack opt = (IAEGasStack)option.copy();
                this.putGasRecord(opt);
            }
        }
    }

    public IAEGasStack findPrecise(IAEGasStack gasStack) {
        return gasStack == null ? null : this.getGasRecord(gasStack);
    }

    public Collection<IAEGasStack> findFuzzy(IAEGasStack filter, FuzzyMode fuzzyMode) {
        return filter == null ? Collections.emptyList() : Collections.singletonList(this.findPrecise(filter));
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    private IAEGasStack getGasRecord(IAEGasStack gas) {
        return this.records.get(gas);
    }

    private void putGasRecord(IAEGasStack gas) {
        this.records.put(gas, gas);
    }
}

