/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.me.storage.impl;

import appeng.api.storage.data.IItemList;
import com.google.common.base.Preconditions;
import com.mekeng.github.common.ItemAndBlocks;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import com.mekeng.github.common.me.storage.impl.GasList;
import com.mekeng.github.util.Utils;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class GasStorageChannel
implements IGasStorageChannel {
    public static GasStorageChannel INSTANCE = new GasStorageChannel();

    private GasStorageChannel() {
    }

    public int transferFactor() {
        return 4000;
    }

    public int getUnitsPerByte() {
        return 32000;
    }

    @Nonnull
    public IItemList<IAEGasStack> createList() {
        return GasList.create();
    }

    @Nullable
    public IAEGasStack createStack(@Nonnull Object input) {
        Preconditions.checkNotNull((Object)input);
        if (input instanceof GasStack) {
            return AEGasStack.of((GasStack)input);
        }
        if (input instanceof ItemStack) {
            ItemStack is = (ItemStack)input;
            return is.func_77973_b() == ItemAndBlocks.DUMMY_GAS ? AEGasStack.of(ItemAndBlocks.DUMMY_GAS.getGasStack(is)) : AEGasStack.of(Utils.getGasFromItem(is));
        }
        return null;
    }

    @Nullable
    public IAEGasStack readFromPacket(@Nonnull ByteBuf input) {
        Preconditions.checkNotNull((Object)input);
        return AEGasStack.of(input);
    }

    @Nullable
    public IAEGasStack createFromNBT(@Nonnull NBTTagCompound nbt) {
        Preconditions.checkNotNull((Object)nbt);
        return AEGasStack.of(nbt);
    }
}

