/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.me.storage.impl;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.StorageFilter;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.ITickingMonitor;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import com.mekeng.github.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import net.minecraft.util.EnumFacing;

public class MEMonitorIGasHandler
implements IMEMonitor<IAEGasStack>,
ITickingMonitor {
    private final IGasHandler handler;
    private final EnumFacing face;
    private IItemList<IAEGasStack> cache = ((IGasStorageChannel)AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)).createList();
    private final HashMap<IMEMonitorHandlerReceiver<IAEGasStack>, Object> listeners = new HashMap();
    private IActionSource mySource;
    private StorageFilter mode = StorageFilter.EXTRACTABLE_ONLY;

    public MEMonitorIGasHandler(IGasHandler handler, EnumFacing face) {
        this.handler = handler;
        this.face = face;
    }

    public void addListener(IMEMonitorHandlerReceiver<IAEGasStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    public void removeListener(IMEMonitorHandlerReceiver<IAEGasStack> l) {
        this.listeners.remove(l);
    }

    public IAEGasStack injectItems(IAEGasStack input, Actionable type, IActionSource src) {
        if (input == null || input.getStackSize() == 0L) {
            return null;
        }
        int filled = this.handler.receiveGas(this.face, input.getGasStack(), type == Actionable.MODULATE);
        if (filled == 0) {
            return (IAEGasStack)input.copy();
        }
        if ((long)filled == input.getStackSize()) {
            return null;
        }
        IAEGasStack o = (IAEGasStack)input.copy();
        o.setStackSize(input.getStackSize() - (long)filled);
        if (type == Actionable.MODULATE) {
            IAEGasStack added = (IAEGasStack)o.copy();
            this.cache.add((IAEStack)added);
            this.postDifference(Collections.singletonList(added));
            this.onTick();
        }
        return o;
    }

    public IAEGasStack extractItems(IAEGasStack request, Actionable type, IActionSource src) {
        IAEGasStack cachedStack;
        if (request == null || request.getStackSize() == 0L) {
            return null;
        }
        GasStack removed = Utils.drawGas(this.handler, request.getGasStack(), this.face, request.getGasStack().amount, type == Actionable.MODULATE);
        if (removed == null || !removed.isGasEqual(request.getGasStack()) || removed.amount == 0) {
            return null;
        }
        IAEGasStack o = (IAEGasStack)request.copy();
        o.setStackSize(removed.amount);
        if (type == Actionable.MODULATE && (cachedStack = (IAEGasStack)this.cache.findPrecise((IAEStack)request)) != null) {
            cachedStack.decStackSize(o.getStackSize());
            this.postDifference(Collections.singletonList(((IAEGasStack)o.copy()).setStackSize(-o.getStackSize())));
        }
        return o;
    }

    public IStorageChannel<IAEGasStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class);
    }

    public TickRateModulation onTick() {
        boolean changed = false;
        ArrayList<IAEGasStack> changes = new ArrayList<IAEGasStack>();
        GasTankInfo[] tankProperties = this.handler.getTankInfo();
        IItemList currentlyOnStorage = ((IGasStorageChannel)AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)).createList();
        for (GasTankInfo tankProperty : tankProperties) {
            if (this.mode == StorageFilter.EXTRACTABLE_ONLY && this.handler.drawGas(this.face, 1, false) == null) continue;
            currentlyOnStorage.add((IAEStack)AEGasStack.of(tankProperty.getGas()));
        }
        for (IAEGasStack is : this.cache) {
            is.setStackSize(-is.getStackSize());
        }
        for (IAEGasStack is : currentlyOnStorage) {
            this.cache.add((IAEStack)is);
        }
        for (IAEGasStack is : this.cache) {
            if (is.getStackSize() == 0L) continue;
            changes.add(is);
        }
        this.cache = currentlyOnStorage;
        if (!changes.isEmpty()) {
            this.postDifference(changes);
            changed = true;
        }
        return changed ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }

    private void postDifference(Iterable<IAEGasStack> a) {
        if (a != null) {
            Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEGasStack>, Object>> i = this.listeners.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<IMEMonitorHandlerReceiver<IAEGasStack>, Object> l = i.next();
                IMEMonitorHandlerReceiver<IAEGasStack> key = l.getKey();
                if (key.isValid(l.getValue())) {
                    key.postChange((IBaseMonitor)this, a, this.getActionSource());
                    continue;
                }
                i.remove();
            }
        }
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public boolean isPrioritized(IAEGasStack input) {
        return false;
    }

    public boolean canAccept(IAEGasStack input) {
        return true;
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return true;
    }

    public IItemList<IAEGasStack> getAvailableItems(IItemList<IAEGasStack> out) {
        for (IAEGasStack fs : this.cache) {
            out.addStorage((IAEStack)fs);
        }
        return out;
    }

    public IItemList<IAEGasStack> getStorageList() {
        return this.cache;
    }

    private StorageFilter getMode() {
        return this.mode;
    }

    public void setMode(StorageFilter mode) {
        this.mode = mode;
    }

    private IActionSource getActionSource() {
        return this.mySource;
    }

    public void setActionSource(IActionSource mySource) {
        this.mySource = mySource;
    }
}

